/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.journal.active;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import org.apache.activeio.adapter.PacketOutputStream;
import org.apache.activeio.adapter.PacketToInputStream;
import org.apache.activeio.journal.active.Location;
import org.apache.activeio.packet.ByteArrayPacket;
import org.apache.activeio.packet.Packet;

public final class Record {
    public static final int RECORD_HEADER_SIZE = 16;
    public static final int RECORD_FOOTER_SIZE = 20;
    public static final int RECORD_BASE_SIZE = 36;
    public static final byte[] START_OF_RECORD = new byte[]{83, 111, 82};
    public static final byte[] END_OF_RECORD = new byte[]{69, 111, 82, 46};
    public static final int SELECTED_CHECKSUM_ALGORITHIM;
    public static final int NO_CHECKSUM_ALGORITHIM = 0;
    public static final int HASH_CHECKSUM_ALGORITHIM = 1;
    public static final int CRC32_CHECKSUM_ALGORITHIM = 2;
    private final ByteArrayPacket headerFooterPacket = new ByteArrayPacket(new byte[36]);
    private final DataOutputStream headerFooterData = new DataOutputStream(new PacketOutputStream(this.headerFooterPacket));
    private int payloadLength;
    private Location location;
    private byte recordType;
    private long checksum;
    private Location mark;
    private Packet payload;

    public static boolean isChecksumingEnabled() {
        return SELECTED_CHECKSUM_ALGORITHIM != 0;
    }

    public Record() {
    }

    public Record(byte recordType, Packet payload, Location mark) throws IOException {
        this(null, recordType, payload, mark);
    }

    public Record(Location location, byte recordType, Packet payload, Location mark) throws IOException {
        this.location = location;
        this.recordType = recordType;
        this.mark = mark;
        this.payload = payload.slice();
        this.payloadLength = payload.remaining();
        if (Record.isChecksumingEnabled()) {
            this.checksum(new DataInputStream(new PacketToInputStream(this.payload)));
        }
        this.writeHeader(this.headerFooterData);
        this.writeFooter(this.headerFooterData);
    }

    public void setLocation(Location location) throws IOException {
        this.location = location;
        this.headerFooterPacket.clear();
        this.headerFooterPacket.position(8);
        location.writeToDataOutput(this.headerFooterData);
        this.headerFooterPacket.position(24);
        location.writeToDataOutput(this.headerFooterData);
        this.payload.clear();
        this.headerFooterPacket.position(0);
        this.headerFooterPacket.limit(16);
    }

    private void writeHeader(DataOutput out) throws IOException {
        out.write(START_OF_RECORD);
        out.writeByte(this.recordType);
        out.writeInt(this.payloadLength);
        if (this.location != null) {
            this.location.writeToDataOutput(out);
        } else {
            out.writeLong(0L);
        }
    }

    public void readHeader(DataInput in) throws IOException {
        this.readAndCheckConstant(in, START_OF_RECORD, "Invalid record header: start of record constant missing.");
        this.recordType = in.readByte();
        this.payloadLength = in.readInt();
        if (this.payloadLength < 0) {
            throw new IOException("Invalid record header: record length cannot be less than zero.");
        }
        this.location = Location.readFromDataInput(in);
    }

    private void writeFooter(DataOutput out) throws IOException {
        out.writeLong(this.checksum);
        if (this.location != null) {
            this.location.writeToDataOutput(out);
        } else {
            out.writeLong(0L);
        }
        out.write(END_OF_RECORD);
    }

    public void readFooter(DataInput in) throws IOException {
        Location loc;
        long l = in.readLong();
        if (Record.isChecksumingEnabled()) {
            if (l != this.checksum) {
                throw new IOException("Invalid record footer: checksum does not match.");
            }
        } else {
            this.checksum = l;
        }
        if (!(loc = Location.readFromDataInput(in)).equals(this.location)) {
            throw new IOException("Invalid record footer: location id does not match.");
        }
        this.readAndCheckConstant(in, END_OF_RECORD, "Invalid record header: end of record constant missing.");
    }

    public void checksum(DataInput in) throws IOException {
        if (SELECTED_CHECKSUM_ALGORITHIM == 1) {
            int l;
            byte[] buffer = new byte[1024];
            byte[] rc = new byte[8];
            for (int i = 0; i < this.payloadLength; i += l) {
                l = Math.min(buffer.length, this.payloadLength - i);
                in.readFully(buffer, 0, l);
                for (int j = 0; j < l; ++j) {
                    int n = j % 8;
                    rc[n] = (byte)(rc[n] ^ buffer[j]);
                }
            }
            this.checksum = rc[0] | rc[1] << 1 | rc[2] << 2 | rc[3] << 3 | rc[4] << 4 | rc[5] << 5 | rc[6] << 6 | rc[7] << 7;
        } else if (SELECTED_CHECKSUM_ALGORITHIM == 2) {
            int l;
            byte[] buffer = new byte[1024];
            CRC32 crc32 = new CRC32();
            for (int i = 0; i < this.payloadLength; i += l) {
                l = Math.min(buffer.length, this.payloadLength - i);
                in.readFully(buffer, 0, l);
                crc32.update(buffer, 0, l);
            }
            this.checksum = crc32.getValue();
        } else {
            this.checksum = 0L;
        }
    }

    private void readAndCheckConstant(DataInput in, byte[] byteConstant, String errorMessage) throws IOException {
        for (int i = 0; i < byteConstant.length; ++i) {
            byte checkByte = byteConstant[i];
            if (in.readByte() == checkByte) continue;
            throw new IOException(errorMessage);
        }
    }

    public boolean readFromPacket(Packet packet) throws IOException {
        Packet dup = packet.duplicate();
        if (dup.remaining() < 16) {
            return false;
        }
        DataInputStream is = new DataInputStream(new PacketToInputStream(dup));
        this.readHeader(is);
        if (dup.remaining() < this.payloadLength + 20) {
            return false;
        }
        dup.limit(dup.position() + this.payloadLength);
        this.payload = dup.slice();
        if (Record.isChecksumingEnabled()) {
            this.checksum(new DataInputStream(new PacketToInputStream(this.payload)));
        }
        dup.limit(packet.limit());
        dup.position(dup.position() + this.payloadLength);
        this.readFooter(is);
        packet.position(dup.position());
        dup.dispose();
        return true;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public int getPayloadLength() {
        return this.payloadLength;
    }

    public int getRecordLength() {
        return this.payloadLength + 36;
    }

    public Location getLocation() {
        return this.location;
    }

    public Location getMark() {
        return this.mark;
    }

    public Packet getPayload() {
        return this.payload;
    }

    public byte getRecordType() {
        return this.recordType;
    }

    public boolean hasRemaining() {
        return this.headerFooterPacket.position() != 36;
    }

    public void read(Packet packet) {
        this.headerFooterPacket.read(packet);
        this.payload.read(packet);
        if (!this.payload.hasRemaining() && this.headerFooterPacket.position() == 16) {
            this.headerFooterPacket.position(16);
            this.headerFooterPacket.limit(36);
            this.headerFooterPacket.read(packet);
        }
    }

    public void dispose() {
        if (this.payload != null) {
            this.payload.dispose();
            this.payload = null;
        }
    }

    static {
        String type = System.getProperty("org.apache.activeio.journal.active.SELECTED_CHECKSUM_ALGORITHIM", "none");
        if ("none".equals(type)) {
            SELECTED_CHECKSUM_ALGORITHIM = 0;
        } else if ("crc32".equals(type)) {
            SELECTED_CHECKSUM_ALGORITHIM = 2;
        } else if ("hash".equals(type)) {
            SELECTED_CHECKSUM_ALGORITHIM = 1;
        } else {
            System.err.println("System property 'org.apache.activeio.journal.active.SELECTED_CHECKSUM_ALGORITHIM' not set properly.  Valid values are: 'none', 'hash', or 'crc32'");
            SELECTED_CHECKSUM_ALGORITHIM = 0;
        }
    }
}

