/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.camel;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fusesource.fabric.camel.FabricComponent;
import org.fusesource.fabric.camel.LoadBalancerFactory;
import org.fusesource.fabric.groups.ChangeListener;
import org.fusesource.fabric.groups.Group;

public class FabricLocatorEndpoint
extends DefaultEndpoint {
    private static final transient Log LOG = LogFactory.getLog(FabricLocatorEndpoint.class);
    private final FabricComponent component;
    private final Group group;
    private LoadBalancerFactory loadBalancerFactory;
    private LoadBalancer loadBalancer;
    private final Map<String, Processor> processors = new HashMap<String, Processor>();

    public FabricLocatorEndpoint(String uri, FabricComponent component, Group group) {
        super(uri, (Component)component);
        this.component = component;
        this.group = group;
    }

    public Producer createProducer() throws Exception {
        FabricLocatorEndpoint endpoint = this;
        return new DefaultProducer((Endpoint)endpoint){

            public void process(Exchange exchange) throws Exception {
                FabricLocatorEndpoint.this.loadBalancer.process(exchange);
            }
        };
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot consume from a FABRIC endpoint using just its fabric name directly, you must use fabric:name:someActualUri instead");
    }

    public boolean isSingleton() {
        return true;
    }

    public void start() throws Exception {
        super.start();
        if (this.loadBalancer == null) {
            this.loadBalancer = this.createLoadBalancer();
        }
        this.group.add(new ChangeListener(){

            public synchronized void changed() {
                String key;
                LinkedHashSet<String> removed = new LinkedHashSet<String>();
                for (Map.Entry entry : FabricLocatorEndpoint.this.processors.entrySet()) {
                    key = (String)entry.getKey();
                    if (FabricLocatorEndpoint.this.group.members().containsKey(key)) continue;
                    removed.add(key);
                }
                for (Map.Entry entry : FabricLocatorEndpoint.this.group.members().entrySet()) {
                    try {
                        key = (String)entry.getKey();
                        if (FabricLocatorEndpoint.this.processors.containsKey(key)) continue;
                        Processor p = FabricLocatorEndpoint.this.getProcessor(new String((byte[])entry.getValue(), "UTF-8"));
                        FabricLocatorEndpoint.this.processors.put(key, p);
                        FabricLocatorEndpoint.this.loadBalancer.addProcessor(p);
                    }
                    catch (UnsupportedEncodingException ignore) {}
                }
                for (String key2 : removed) {
                    Processor p = (Processor)FabricLocatorEndpoint.this.processors.remove(key2);
                    FabricLocatorEndpoint.this.loadBalancer.removeProcessor(p);
                }
            }

            public void connected() {
                this.changed();
            }

            public void disconnected() {
                this.changed();
            }
        });
    }

    public void stop() throws Exception {
        super.stop();
        this.group.close();
    }

    public Processor getProcessor(String uri) {
        final Endpoint endpoint = this.getCamelContext().getEndpoint(uri);
        return new Processor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void process(Exchange exchange) throws Exception {
                ProducerCache producerCache = FabricLocatorEndpoint.this.component.getProducerCache();
                Producer producer = producerCache.acquireProducer(endpoint);
                try {
                    producer.process(exchange);
                }
                finally {
                    producerCache.releaseProducer(endpoint, producer);
                }
            }

            public String toString() {
                return "Producer for " + endpoint;
            }
        };
    }

    public FabricComponent getComponent() {
        return this.component;
    }

    public LoadBalancerFactory getLoadBalancerFactory() {
        if (this.loadBalancerFactory == null) {
            this.loadBalancerFactory = this.component.getLoadBalancerFactory();
        }
        return this.loadBalancerFactory;
    }

    public void setLoadBalancerFactory(LoadBalancerFactory loadBalancerFactory) {
        this.loadBalancerFactory = loadBalancerFactory;
    }

    public LoadBalancer createLoadBalancer() {
        return this.getLoadBalancerFactory().createLoadBalancer();
    }
}

