/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.login;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.inject.ImplementedBy;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import org.jclouds.crypto.Sha512Crypt;
import org.jclouds.domain.Credentials;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.statements.login.AdminAccessBuilderSpec;
import org.jclouds.scriptbuilder.statements.login.DefaultConfiguration;
import org.jclouds.scriptbuilder.statements.login.ShadowStatements;
import org.jclouds.scriptbuilder.statements.login.SudoStatements;
import org.jclouds.scriptbuilder.statements.login.UserAdd;
import org.jclouds.scriptbuilder.statements.ssh.SshStatements;

public class AdminAccess
implements Statement {
    @VisibleForTesting
    Config config;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Function<String, String> cryptFunction) {
        return new Builder(cryptFunction);
    }

    public static AdminAccess standard() {
        return new Builder().build();
    }

    protected AdminAccess(Config in) {
        this.config = (Config)Preconditions.checkNotNull((Object)in, (Object)"in");
    }

    @Nullable
    public Credentials getAdminCredentials() {
        return this.config.getAdminCredentials();
    }

    @Nullable
    public String getAdminPassword() {
        return this.config.getAdminPassword();
    }

    public boolean shouldGrantSudoToAdminUser() {
        return this.config.shouldGrantSudoToAdminUser();
    }

    @Override
    public Iterable<String> functionDependencies(OsFamily family) {
        return ImmutableList.of();
    }

    public AdminAccess init(Configuration configuration) {
        Builder builder = AdminAccess.builder(configuration.cryptFunction());
        builder.adminUsername(this.config.getAdminUsername() != null ? this.config.getAdminUsername() : (String)configuration.defaultAdminUsername().get());
        builder.adminFullName(this.config.getAdminFullName() != null ? this.config.getAdminFullName() : builder.adminUsername);
        builder.adminHome(this.config.getAdminHome());
        builder.adminPassword(this.config.getAdminPassword() != null ? this.config.getAdminPassword() : (String)configuration.passwordGenerator().get());
        Map adminSshKeys = this.config.getAdminPublicKey() != null && this.config.getAdminPrivateKey() != null ? ImmutableMap.of((Object)"public", (Object)this.config.getAdminPublicKey(), (Object)"private", (Object)this.config.getAdminPrivateKey()) : (Map)configuration.defaultAdminSshKeys().get();
        builder.adminPublicKey((String)adminSshKeys.get("public"));
        builder.adminPrivateKey((String)adminSshKeys.get("private"));
        builder.loginPassword(this.config.getLoginPassword() != null ? this.config.getLoginPassword() : (String)configuration.passwordGenerator().get());
        builder.grantSudoToAdminUser(this.config.shouldGrantSudoToAdminUser());
        builder.authorizeAdminPublicKey(this.config.shouldAuthorizeAdminPublicKey());
        builder.installAdminPrivateKey(this.config.shouldInstallAdminPrivateKey());
        builder.lockSsh(this.config.shouldLockSsh());
        builder.resetLoginPassword(this.config.shouldResetLoginPassword());
        this.config = builder.buildConfig();
        return this;
    }

    @Override
    public String render(OsFamily family) {
        Preconditions.checkNotNull((Object)((Object)family), (Object)"family");
        if (family == OsFamily.WINDOWS) {
            throw new UnsupportedOperationException("windows not yet implemented");
        }
        Preconditions.checkArgument((!"root".equals(this.config.getAdminUsername()) ? 1 : 0) != 0, (Object)"cannot create admin user 'root'; ensure jclouds is not running as root, or specify an explicit non-root username in AdminAccess");
        if (Iterables.any((Iterable)Lists.newArrayList((Object[])new String[]{this.config.getAdminUsername(), this.config.getAdminPassword(), this.config.getAdminPublicKey(), this.config.getAdminPrivateKey(), this.config.getLoginPassword()}), (Predicate)Predicates.isNull())) {
            this.init(new DefaultConfiguration());
        }
        Preconditions.checkNotNull((Object)this.config.getAdminUsername(), (Object)"adminUsername");
        Preconditions.checkNotNull((Object)this.config.getAdminPassword(), (Object)"adminPassword");
        Preconditions.checkNotNull((Object)this.config.getAdminPublicKey(), (Object)"adminPublicKey");
        Preconditions.checkNotNull((Object)this.config.getAdminPrivateKey(), (Object)"adminPrivateKey");
        Preconditions.checkNotNull((Object)this.config.getLoginPassword(), (Object)"loginPassword");
        ImmutableList.Builder statements = ImmutableList.builder();
        UserAdd.Builder userBuilder = UserAdd.builder();
        userBuilder.login(this.config.getAdminUsername());
        userBuilder.fullName(this.config.getAdminFullName());
        if (this.config.getAdminHome() != null) {
            userBuilder.home(this.config.getAdminHome());
        }
        if (this.config.shouldAuthorizeAdminPublicKey()) {
            userBuilder.authorizeRSAPublicKey(this.config.getAdminPublicKey());
        }
        userBuilder.password(this.config.getAdminPassword());
        if (this.config.shouldInstallAdminPrivateKey()) {
            userBuilder.installRSAPrivateKey(this.config.getAdminPrivateKey());
        }
        if (this.config.shouldGrantSudoToAdminUser()) {
            statements.add((Object)SudoStatements.createWheel());
            userBuilder.group("wheel");
        }
        statements.add((Object)userBuilder.build().cryptFunction(this.config.getCryptFunction()));
        if (this.config.shouldLockSsh()) {
            statements.add((Object)SshStatements.lockSshd());
        }
        if (this.config.shouldResetLoginPassword()) {
            statements.add((Object)ShadowStatements.resetLoginUserPasswordTo(this.config.getLoginPassword()).cryptFunction(this.config.getCryptFunction()));
        }
        return new StatementList((Iterable<Statement>)statements.build()).render(family);
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("AdminAccess [config=").append(this.config).append(", getAdminCredentials()=").append(this.getAdminCredentials()).append(", shouldGrantSudoToAdminUser()=").append(this.shouldGrantSudoToAdminUser()).append("]");
        return builder2.toString();
    }

    protected static class Config {
        private final String adminUsername;
        private final String adminFullName;
        private final String adminHome;
        private final String adminPublicKey;
        private final String adminPrivateKey;
        private final String adminPassword;
        private final String loginPassword;
        private final boolean grantSudoToAdminUser;
        private final boolean installAdminPrivateKey;
        private final boolean resetLoginPassword;
        private final Function<String, String> cryptFunction;
        private final Credentials adminCredentials;
        private boolean authorizeAdminPublicKey;
        private boolean lockSsh;

        protected Config(@Nullable String adminUsername, @Nullable String adminFullName, @Nullable String adminHome, @Nullable String adminPublicKey, @Nullable String adminPrivateKey, @Nullable String adminPassword, @Nullable String loginPassword, boolean lockSsh, boolean grantSudoToAdminUser, boolean authorizeAdminPublicKey, boolean installAdminPrivateKey, boolean resetLoginPassword, Function<String, String> cryptFunction) {
            this.adminUsername = adminUsername;
            this.adminFullName = adminFullName;
            this.adminHome = adminHome;
            this.adminPublicKey = adminPublicKey;
            this.adminPrivateKey = adminPrivateKey;
            this.adminPassword = adminPassword;
            this.loginPassword = loginPassword;
            this.lockSsh = lockSsh;
            this.grantSudoToAdminUser = grantSudoToAdminUser;
            this.authorizeAdminPublicKey = authorizeAdminPublicKey;
            this.installAdminPrivateKey = installAdminPrivateKey;
            this.resetLoginPassword = resetLoginPassword;
            this.cryptFunction = cryptFunction;
            if (adminUsername != null && authorizeAdminPublicKey && adminPrivateKey != null) {
                this.adminCredentials = new Credentials(adminUsername, adminPrivateKey);
            } else if (adminUsername != null && adminPassword != null) {
                this.adminCredentials = new Credentials(adminUsername, adminPassword);
                this.authorizeAdminPublicKey = false;
                this.lockSsh = false;
            } else {
                this.adminCredentials = null;
            }
        }

        public String getAdminUsername() {
            return this.adminUsername;
        }

        public String getAdminFullName() {
            return this.adminFullName;
        }

        public String getAdminHome() {
            return this.adminHome;
        }

        public String getAdminPublicKey() {
            return this.adminPublicKey;
        }

        public String getAdminPrivateKey() {
            return this.adminPrivateKey;
        }

        public String getAdminPassword() {
            return this.adminPassword;
        }

        public String getLoginPassword() {
            return this.loginPassword;
        }

        public boolean shouldLockSsh() {
            return this.lockSsh;
        }

        public boolean shouldGrantSudoToAdminUser() {
            return this.grantSudoToAdminUser;
        }

        public boolean shouldAuthorizeAdminPublicKey() {
            return this.authorizeAdminPublicKey;
        }

        public boolean shouldInstallAdminPrivateKey() {
            return this.installAdminPrivateKey;
        }

        public boolean shouldResetLoginPassword() {
            return this.resetLoginPassword;
        }

        public Function<String, String> getCryptFunction() {
            return this.cryptFunction;
        }

        public Credentials getAdminCredentials() {
            return this.adminCredentials;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Config [adminUsername=").append(this.adminUsername).append(", adminFullName=").append(this.adminFullName).append(", adminHome=").append(this.adminHome).append(", adminPublicKey=").append(this.adminPublicKey == null ? "null" : "present").append(", adminPrivateKey=").append(this.adminPrivateKey == null ? "null" : "present").append(", adminPassword=").append(this.adminPassword == null ? "null" : "present").append(", loginPassword=").append(this.loginPassword == null ? "null" : "present").append(", lockSsh=").append(this.lockSsh).append(", grantSudoToAdminUser=").append(this.grantSudoToAdminUser).append(", authorizeAdminPublicKey=").append(this.authorizeAdminPublicKey).append(", installAdminPrivateKey=").append(this.installAdminPrivateKey).append(", resetLoginPassword=").append(this.resetLoginPassword).append(", cryptFunction=").append(this.cryptFunction).append(", adminCredentials=").append(this.adminCredentials).append("]");
            return builder.toString();
        }
    }

    public static class Builder {
        private final Function<String, String> cryptFunction;
        private String adminUsername;
        private String adminFullName;
        private String adminHome;
        private String adminPublicKey;
        private File adminPublicKeyFile;
        private String adminPrivateKey;
        private File adminPrivateKeyFile;
        private String adminPassword;
        private String loginPassword;
        private boolean lockSsh = true;
        private boolean grantSudoToAdminUser = true;
        private boolean authorizeAdminPublicKey = true;
        private boolean installAdminPrivateKey = false;
        private boolean resetLoginPassword = true;

        public Builder() {
            this((Function<String, String>)Sha512Crypt.function());
        }

        public Builder(Function<String, String> cryptFunction) {
            this.cryptFunction = cryptFunction;
        }

        public Builder adminUsername(String adminUsername) {
            this.adminUsername = adminUsername;
            return this;
        }

        public Builder adminFullName(String adminFullName) {
            this.adminFullName = adminFullName;
            return this;
        }

        public Builder adminHome(String adminHome) {
            this.adminHome = adminHome;
            return this;
        }

        public Builder adminPassword(String adminPassword) {
            this.adminPassword = adminPassword;
            return this;
        }

        public Builder loginPassword(String loginPassword) {
            this.loginPassword = loginPassword;
            return this;
        }

        public Builder lockSsh(boolean lockSsh) {
            this.lockSsh = lockSsh;
            return this;
        }

        public Builder resetLoginPassword(boolean resetLoginPassword) {
            this.resetLoginPassword = resetLoginPassword;
            return this;
        }

        public Builder authorizeAdminPublicKey(boolean authorizeAdminPublicKey) {
            this.authorizeAdminPublicKey = authorizeAdminPublicKey;
            return this;
        }

        public Builder installAdminPrivateKey(boolean installAdminPrivateKey) {
            this.installAdminPrivateKey = installAdminPrivateKey;
            return this;
        }

        public Builder grantSudoToAdminUser(boolean grantSudoToAdminUser) {
            this.grantSudoToAdminUser = grantSudoToAdminUser;
            return this;
        }

        public Builder adminPublicKey(File adminPublicKey) {
            this.adminPublicKeyFile = adminPublicKey;
            this.adminPublicKey = null;
            return this;
        }

        public Builder adminPublicKey(String adminPublicKey) {
            this.adminPublicKey = adminPublicKey;
            this.adminPublicKeyFile = null;
            return this;
        }

        public Builder adminPrivateKey(File adminPrivateKey) {
            this.adminPrivateKeyFile = adminPrivateKey;
            this.adminPrivateKey = null;
            return this;
        }

        public Builder adminPrivateKey(String adminPrivateKey) {
            this.adminPrivateKey = adminPrivateKey;
            this.adminPrivateKeyFile = null;
            return this;
        }

        public Builder from(AdminAccessBuilderSpec spec) {
            return spec.copyTo(this);
        }

        public Builder from(String spec) {
            return this.from(AdminAccessBuilderSpec.parse(spec));
        }

        public AdminAccess build() {
            return new AdminAccess(this.buildConfig());
        }

        protected Config buildConfig() {
            try {
                String adminPrivateKey;
                String adminPublicKey = this.adminPublicKey;
                if (adminPublicKey == null && this.adminPublicKeyFile != null) {
                    adminPublicKey = Files.toString((File)this.adminPublicKeyFile, (Charset)Charsets.UTF_8);
                }
                if ((adminPrivateKey = this.adminPrivateKey) == null && this.adminPrivateKeyFile != null) {
                    adminPrivateKey = Files.toString((File)this.adminPrivateKeyFile, (Charset)Charsets.UTF_8);
                }
                return new Config(this.adminUsername, this.adminFullName, this.adminHome, adminPublicKey, adminPrivateKey, this.adminPassword, this.loginPassword, this.lockSsh, this.grantSudoToAdminUser, this.authorizeAdminPublicKey, this.installAdminPrivateKey, this.resetLoginPassword, this.cryptFunction);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    @ImplementedBy(value=DefaultConfiguration.class)
    public static interface Configuration {
        public Supplier<String> defaultAdminUsername();

        public Supplier<Map<String, String>> defaultAdminSshKeys();

        public Supplier<String> passwordGenerator();

        public Function<String, String> cryptFunction();
    }
}

