/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import org.apache.activemq.broker.jmx.ManagedRegionBroker;
import org.apache.activemq.broker.jmx.RecoveredXATransactionViewMBean;
import org.apache.activemq.transaction.Synchronization;
import org.apache.activemq.transaction.XATransaction;

public class RecoveredXATransactionView
implements RecoveredXATransactionViewMBean {
    private final XATransaction transaction;

    public RecoveredXATransactionView(final ManagedRegionBroker managedRegionBroker, final XATransaction transaction2) {
        this.transaction = transaction2;
        transaction2.addSynchronization(new Synchronization(){

            @Override
            public void afterCommit() throws Exception {
                managedRegionBroker.unregister(transaction2);
            }

            @Override
            public void afterRollback() throws Exception {
                managedRegionBroker.unregister(transaction2);
            }
        });
    }

    @Override
    public int getFormatId() {
        return this.transaction.getXid().getFormatId();
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.transaction.getXid().getBranchQualifier();
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.transaction.getXid().getGlobalTransactionId();
    }

    @Override
    public void heuristicCommit() throws Exception {
        this.transaction.commit(false);
    }

    @Override
    public void heuristicRollback() throws Exception {
        this.transaction.rollback();
    }
}

