/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.activemq.broker.AbstractLocker;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.jdbc.Statements;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaseDatabaseLocker
extends AbstractLocker {
    private static final Logger LOG = LoggerFactory.getLogger(LeaseDatabaseLocker.class);
    protected DataSource dataSource;
    protected Statements statements;
    protected boolean stopping;
    protected int maxAllowableDiffFromDBTime = 0;
    protected long diffFromCurrentTime = Long.MAX_VALUE;
    protected String leaseHolderId;
    protected int queryTimeout = -1;
    JDBCPersistenceAdapter persistenceAdapter;
    protected boolean handleStartException;

    @Override
    public void configure(PersistenceAdapter adapter) throws IOException {
        if (adapter instanceof JDBCPersistenceAdapter) {
            this.persistenceAdapter = (JDBCPersistenceAdapter)adapter;
            this.dataSource = ((JDBCPersistenceAdapter)adapter).getLockDataSource();
            this.statements = ((JDBCPersistenceAdapter)adapter).getStatements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStart() throws Exception {
        this.stopping = false;
        if (this.lockAcquireSleepInterval < this.persistenceAdapter.getLockKeepAlivePeriod()) {
            LOG.warn("Persistence adapter keep alive period: " + this.persistenceAdapter.getLockKeepAlivePeriod() + ", which renews the lease, is less than lockAcquireSleepInterval: " + this.lockAcquireSleepInterval + ", the lease duration. These values will allow the lease to expire.");
        }
        LOG.info(this.getLeaseHolderId() + " attempting to acquire exclusive lease to become the Master broker");
        String sql = this.statements.getLeaseObtainStatement();
        LOG.debug(this.getLeaseHolderId() + " locking Query is " + sql);
        long now = 0L;
        while (!this.stopping) {
            PreparedStatement statement;
            Connection connection;
            block10: {
                connection = null;
                statement = null;
                connection = this.getConnection();
                this.initTimeDiff(connection);
                statement = connection.prepareStatement(sql);
                this.setQueryTimeout(statement);
                now = System.currentTimeMillis() + this.diffFromCurrentTime;
                statement.setString(1, this.getLeaseHolderId());
                statement.setLong(2, now + this.lockAcquireSleepInterval);
                statement.setLong(3, now);
                int result = statement.executeUpdate();
                if (result != 1 || !this.keepAlive()) break block10;
                this.close(statement);
                this.close(connection);
                break;
            }
            try {
                this.reportLeasOwnerShipAndDuration(connection);
                this.close(statement);
                this.close(connection);
            }
            catch (Exception e) {
                try {
                    LOG.debug(this.getLeaseHolderId() + " lease acquire failure: " + e, (Throwable)e);
                    if (this.isStopping()) {
                        throw new Exception("Cannot start broker as being asked to shut down. Interrupted attempt to acquire lock: " + e, e);
                    }
                    if (this.handleStartException) {
                        this.persistenceAdapter.getBrokerService().handleIOException(IOExceptionSupport.create(e));
                    }
                    this.close(statement);
                    this.close(connection);
                }
                catch (Throwable throwable) {
                    this.close(statement);
                    this.close(connection);
                    throw throwable;
                }
            }
            LOG.info(this.getLeaseHolderId() + " failed to acquire lease.  Sleeping for " + this.lockAcquireSleepInterval + " milli(s) before trying again...");
            TimeUnit.MILLISECONDS.sleep(this.lockAcquireSleepInterval);
        }
        if (this.stopping) {
            throw new RuntimeException(this.getLeaseHolderId() + " failing lease acquire due to stop");
        }
        LOG.info(this.getLeaseHolderId() + ", becoming master with lease expiry " + new Date(now) + " on dataSource: " + this.dataSource);
    }

    private void setQueryTimeout(PreparedStatement statement) throws SQLException {
        if (this.queryTimeout > 0) {
            statement.setQueryTimeout(this.queryTimeout);
        }
    }

    private Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    private void close(Connection connection) {
        if (null != connection) {
            try {
                connection.close();
            }
            catch (SQLException e1) {
                LOG.debug(this.getLeaseHolderId() + " caught exception while closing connection: " + e1, (Throwable)e1);
            }
        }
    }

    private void close(PreparedStatement statement) {
        if (null != statement) {
            try {
                statement.close();
            }
            catch (SQLException e1) {
                LOG.debug(this.getLeaseHolderId() + ", caught while closing statement: " + e1, (Throwable)e1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportLeasOwnerShipAndDuration(Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(this.statements.getLeaseOwnerStatement());
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                LOG.info(this.getLeaseHolderId() + " Lease held by " + resultSet.getString(1) + " till " + new Date(resultSet.getLong(2)));
            }
            this.close(statement);
        }
        catch (Throwable throwable) {
            this.close(statement);
            throw throwable;
        }
    }

    protected long initTimeDiff(Connection connection) throws SQLException {
        if (Long.MAX_VALUE == this.diffFromCurrentTime) {
            this.diffFromCurrentTime = this.maxAllowableDiffFromDBTime > 0 ? this.determineTimeDifference(connection) : 0L;
        }
        return this.diffFromCurrentTime;
    }

    protected long determineTimeDifference(Connection connection) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(this.statements.getCurrentDateTime());
        ResultSet resultSet = statement.executeQuery();
        long result = 0L;
        if (resultSet.next()) {
            Timestamp timestamp = resultSet.getTimestamp(1);
            long diff = System.currentTimeMillis() - timestamp.getTime();
            if (Math.abs(diff) > (long)this.maxAllowableDiffFromDBTime) {
                result = -diff;
            }
            LOG.info(this.getLeaseHolderId() + " diff adjust from db: " + result + ", db time: " + timestamp);
        }
        return result;
    }

    @Override
    public void doStop(ServiceStopper stopper) throws Exception {
        this.stopping = true;
        if (this.persistenceAdapter.getBrokerService() != null && this.persistenceAdapter.getBrokerService().isRestartRequested()) {
            return;
        }
        this.releaseLease();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLease() {
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement(this.statements.getLeaseUpdateStatement());
            statement.setString(1, null);
            statement.setLong(2, 0L);
            statement.setString(3, this.getLeaseHolderId());
            if (statement.executeUpdate() == 1) {
                LOG.info(this.getLeaseHolderId() + ", released lease");
            }
            this.close(statement);
            this.close(connection);
        }
        catch (Exception e) {
            try {
                LOG.error(this.getLeaseHolderId() + " failed to release lease: " + e, (Throwable)e);
                this.close(statement);
                this.close(connection);
            }
            catch (Throwable throwable) {
                this.close(statement);
                this.close(connection);
                throw throwable;
            }
        }
    }

    @Override
    public boolean keepAlive() throws IOException {
        boolean result = false;
        String sql = this.statements.getLeaseUpdateStatement();
        LOG.debug(this.getLeaseHolderId() + ", lease keepAlive Query is " + sql);
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.getConnection();
            this.initTimeDiff(connection);
            statement = connection.prepareStatement(sql);
            this.setQueryTimeout(statement);
            long now = System.currentTimeMillis() + this.diffFromCurrentTime;
            statement.setString(1, this.getLeaseHolderId());
            statement.setLong(2, now + this.lockAcquireSleepInterval);
            statement.setString(3, this.getLeaseHolderId());
            boolean bl = result = statement.executeUpdate() == 1;
            if (!result) {
                this.reportLeasOwnerShipAndDuration(connection);
            }
            this.close(statement);
            this.close(connection);
        }
        catch (Exception e) {
            try {
                LOG.warn(this.getLeaseHolderId() + ", failed to update lease: " + e, (Throwable)e);
                IOException ioe = IOExceptionSupport.create(e);
                this.persistenceAdapter.getBrokerService().handleIOException(ioe);
                throw ioe;
            }
            catch (Throwable throwable) {
                this.close(statement);
                this.close(connection);
                throw throwable;
            }
        }
        return result;
    }

    public long getLockAcquireSleepInterval() {
        return this.lockAcquireSleepInterval;
    }

    @Override
    public void setLockAcquireSleepInterval(long lockAcquireSleepInterval) {
        this.lockAcquireSleepInterval = lockAcquireSleepInterval;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public String getLeaseHolderId() {
        if (this.leaseHolderId == null && this.persistenceAdapter.getBrokerService() != null) {
            this.leaseHolderId = this.persistenceAdapter.getBrokerService().getBrokerName();
        }
        return this.leaseHolderId;
    }

    public void setLeaseHolderId(String leaseHolderId) {
        this.leaseHolderId = leaseHolderId;
    }

    public int getMaxAllowableDiffFromDBTime() {
        return this.maxAllowableDiffFromDBTime;
    }

    public void setMaxAllowableDiffFromDBTime(int maxAllowableDiffFromDBTime) {
        this.maxAllowableDiffFromDBTime = maxAllowableDiffFromDBTime;
    }

    public boolean isHandleStartException() {
        return this.handleStartException;
    }

    public void setHandleStartException(boolean handleStartException) {
        this.handleStartException = handleStartException;
    }

    public String toString() {
        return "LeaseDatabaseLocker owner:" + this.leaseHolderId + ",duration:" + this.lockAcquireSleepInterval + ",renew:" + this.lockAcquireSleepInterval;
    }
}

