/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.jms;

import java.nio.ByteBuffer;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.codec.CompositeWritableBuffer;
import org.apache.qpid.proton.codec.DroppingWritableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.jms.EncodedMessage;
import org.apache.qpid.proton.jms.JMSVendor;
import org.apache.qpid.proton.jms.OutboundTransformer;
import org.apache.qpid.proton.message.impl.MessageImpl;

public class AMQPNativeOutboundTransformer
extends OutboundTransformer {
    public AMQPNativeOutboundTransformer(JMSVendor vendor) {
        super(vendor);
    }

    @Override
    public EncodedMessage transform(Message msg) throws Exception {
        if (msg == null) {
            return null;
        }
        if (!(msg instanceof BytesMessage)) {
            return null;
        }
        try {
            if (!msg.getBooleanProperty(this.prefixVendor + "NATIVE")) {
                return null;
            }
        }
        catch (MessageFormatException e) {
            return null;
        }
        return AMQPNativeOutboundTransformer.transform(this, (BytesMessage)msg);
    }

    static EncodedMessage transform(OutboundTransformer options, BytesMessage msg) throws JMSException {
        long messageFormat;
        try {
            messageFormat = msg.getLongProperty(options.prefixVendor + "MESSAGE_FORMAT");
        }
        catch (MessageFormatException e) {
            return null;
        }
        byte[] data = new byte[(int)msg.getBodyLength()];
        int dataSize = data.length;
        msg.readBytes(data);
        msg.reset();
        try {
            int count = msg.getIntProperty("JMSXDeliveryCount");
            if (count > 1) {
                int decoded;
                MessageImpl amqp = new MessageImpl();
                int offset = 0;
                for (int len = data.length; len > 0; len -= decoded) {
                    decoded = amqp.decode(data, offset, len);
                    assert (decoded > 0) : "Make progress decoding the message";
                    offset += decoded;
                }
                amqp.getHeader().setDeliveryCount(new UnsignedInteger(count));
                ByteBuffer buffer = ByteBuffer.wrap(new byte[4096]);
                DroppingWritableBuffer overflow = new DroppingWritableBuffer();
                int c = amqp.encode(new CompositeWritableBuffer(new WritableBuffer.ByteBufferWrapper(buffer), overflow));
                if (overflow.position() > 0) {
                    buffer = ByteBuffer.wrap(new byte[4096 + overflow.position()]);
                    c = amqp.encode(new WritableBuffer.ByteBufferWrapper(buffer));
                }
                data = buffer.array();
                dataSize = c;
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        return new EncodedMessage(messageFormat, data, 0, dataSize);
    }
}

