/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.itests;

import de.kalpatec.pojosr.framework.launch.BundleDescriptor;
import de.kalpatec.pojosr.framework.launch.ClasspathScanner;
import de.kalpatec.pojosr.framework.launch.PojoServiceRegistry;
import de.kalpatec.pojosr.framework.launch.PojoServiceRegistryFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ServiceLoader;
import javax.management.MBeanServer;
import org.fusesource.fabric.api.FabricService;
import org.fusesource.fabric.api.ZooKeeperClusterService;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.fabric.zookeeper.internal.OsgiZkClient;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedFabricService {
    private static final Logger log = LoggerFactory.getLogger((String)"Test Registry");
    private PojoServiceRegistry registry = null;

    public void start() throws Exception {
        System.setProperty("org.osgi.framework.storage", "target/osgi/" + System.currentTimeMillis());
        System.setProperty("karaf.name", "root");
        List bundles = new ClasspathScanner().scanForBundles();
        log.info("Located following bundles on classpath : ");
        for (BundleDescriptor desc : bundles) {
            log.debug("Bundle : {}", (Object)desc);
        }
        HashMap<String, List> config = new HashMap<String, List>();
        config.put(PojoServiceRegistryFactory.BUNDLE_DESCRIPTORS, bundles);
        ServiceLoader<PojoServiceRegistryFactory> loader = ServiceLoader.load(PojoServiceRegistryFactory.class);
        this.registry = loader.iterator().next().newPojoServiceRegistry(config);
        this.registry.addServiceListener(new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                ServiceReference ref = event.getServiceReference();
                Object service = EmbeddedFabricService.this.registry.getService(ref);
                switch (event.getType()) {
                    case 2: {
                        log.info("Service modified : " + service);
                        break;
                    }
                    case 8: {
                        log.info("Service modified endmatch : " + service);
                        break;
                    }
                    case 1: {
                        log.info("Service registering : " + service);
                        break;
                    }
                    case 4: {
                        log.info("Service unregistering : " + service);
                        break;
                    }
                    default: {
                        log.info("Unknown event : " + event.getType() + " service : " + service);
                    }
                }
            }
        });
        this.getConfigAdmin();
        EmbeddedFabricService.getService(MBeanServer.class, this.registry);
        this.getZooKeeperClusterService();
        this.createZooKeeperCluster();
        IZKClient client = this.getZooKeeperClient();
        ((OsgiZkClient)client).waitForConnected();
        this.getFabricService();
        this.dumpBundles();
        this.dumpServiceReferences();
    }

    public void dumpBundles() {
        BundleContext bc = this.registry.getBundleContext();
        block8: for (Bundle b : bc.getBundles()) {
            switch (b.getState()) {
                case 32: {
                    log.debug(String.format("Found bundle : %s with version %s in state ACTIVE", b.getSymbolicName(), b.getVersion()));
                    continue block8;
                }
                case 2: {
                    log.debug(String.format("Found bundle : %s with version %s in state INSTALLED", b.getSymbolicName(), b.getVersion()));
                    continue block8;
                }
                case 4: {
                    log.debug(String.format("Found bundle : %s with version %s in state RESOLVED", b.getSymbolicName(), b.getVersion()));
                    continue block8;
                }
                case 8: {
                    log.debug(String.format("Found bundle : %s with version %s in state STARTING", b.getSymbolicName(), b.getVersion()));
                    continue block8;
                }
                case 16: {
                    log.debug(String.format("Found bundle : %s with version %s in state STOPPING", b.getSymbolicName(), b.getVersion()));
                    continue block8;
                }
                case 1: {
                    log.debug(String.format("Found bundle : %s with version %s in state UNINSTALLED", b.getSymbolicName(), b.getVersion()));
                    continue block8;
                }
                default: {
                    log.debug(String.format("Found bundle : %s with version %s in state %s", b.getSymbolicName(), b.getVersion(), b.getState()));
                }
            }
        }
    }

    public void dumpServiceReferences() throws Exception {
        BundleContext bc = this.registry.getBundleContext();
        for (ServiceReference ref : bc.getAllServiceReferences(null, null)) {
            log.debug(String.format("Found Service reference : %s", ref.toString()));
        }
    }

    public void stop() {
        BundleContext bc = this.registry.getBundleContext();
        for (Bundle b : bc.getBundles()) {
            log.debug(String.format("Stopping bundle : %s", b.getSymbolicName()));
            try {
                b.stop();
            }
            catch (BundleException e) {
                e.printStackTrace();
            }
        }
        this.registry = null;
    }

    public PojoServiceRegistry getRegistry() {
        return this.registry;
    }

    public static <T> T getService(Class<T> type, String filter, PojoServiceRegistry registry) {
        try {
            ServiceReference[] ref = registry.getServiceReferences(type.getName(), filter);
            if (ref == null) {
                return null;
            }
            if (ref.length > 1 || ref.length == 0) {
                return null;
            }
            return type.cast(registry.getService(ref[0]));
        }
        catch (InvalidSyntaxException e) {
            return null;
        }
    }

    public static <T> T getService(Class<T> type, PojoServiceRegistry registry) {
        Object rc;
        ServiceTracker tracker = new ServiceTracker(registry.getBundleContext(), type.getName(), null);
        tracker.open(true);
        try {
            rc = tracker.waitForService(60000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to wait for service", e);
        }
        if (rc == null) {
            throw new RuntimeException("Failed to get service");
        }
        tracker.close();
        return type.cast(rc);
    }

    public ConfigurationAdmin getConfigAdmin() {
        return EmbeddedFabricService.getService(ConfigurationAdmin.class, this.registry);
    }

    public ZooKeeperClusterService getZooKeeperClusterService() throws Exception {
        return EmbeddedFabricService.getService(ZooKeeperClusterService.class, this.getRegistry());
    }

    public void createZooKeeperCluster() throws Exception {
        ZooKeeperClusterService clusterService = this.getZooKeeperClusterService();
        clusterService.clean();
        clusterService.createCluster(Arrays.asList("root"));
    }

    public FabricService getFabricService() throws Exception {
        FabricService service = EmbeddedFabricService.getService(FabricService.class, this.getRegistry());
        return service;
    }

    public IZKClient getZooKeeperClient() throws Exception {
        return EmbeddedFabricService.getService(IZKClient.class, this.getRegistry());
    }
}

