/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.client;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.openshift.client.OpenShiftException;
import com.openshift.client.SSHKeyType;
import com.openshift.client.utils.Base64Coder;
import com.openshift.internal.client.ssh.AbstractSSHKey;
import com.openshift.internal.client.utils.Assert;

public class SSHKeyPair
extends AbstractSSHKey {
    private static final int KEYLENGTH = 2048;
    private static final String ID = "com.openshift.client.rest";
    private KeyPair keyPair;
    private String privateKeyPath;
    private String publicKeyPath;

    private SSHKeyPair(KeyPair keyPair, String privateKeyPath, String publicKeyPath, String keyTypeId) throws OpenShiftException {
        this(keyPair, privateKeyPath, publicKeyPath, SSHKeyType.getByTypeId(keyTypeId));
    }

    private SSHKeyPair(KeyPair keyPair, String privateKeyPath, String publicKeyPath, SSHKeyType sshKeyType) throws OpenShiftException {
        super(sshKeyType);
        this.keyPair = keyPair;
        this.privateKeyPath = privateKeyPath;
        this.publicKeyPath = publicKeyPath;
    }

    public static SSHKeyPair create(String passPhrase, String privateKeyPath, String publicKeyPath) throws OpenShiftException {
        Assert.notNull(privateKeyPath);
        Assert.notNull(publicKeyPath);
        return SSHKeyPair.create(SSHKeyType.SSH_RSA, passPhrase, privateKeyPath, publicKeyPath);
    }

    public static SSHKeyPair create(SSHKeyType type, String passPhrase, String privateKeyPath, String publicKeyPath) throws OpenShiftException {
        try {
            KeyPair keyPair = KeyPair.genKeyPair((JSch)new JSch(), (int)2, (int)2048);
            keyPair.setPassphrase(passPhrase);
            keyPair.writePublicKey(publicKeyPath, "created by com.openshift.client.rest");
            keyPair.writePrivateKey(privateKeyPath);
            return new SSHKeyPair(keyPair, privateKeyPath, publicKeyPath, SSHKeyType.SSH_RSA);
        }
        catch (Exception e) {
            throw new OpenShiftException(e, "Could not create new rsa key", e);
        }
    }

    public static SSHKeyPair load(String privateKeyPath, String publicKeyPath) throws OpenShiftException {
        try {
            KeyPair keyPair = KeyPair.load((JSch)new JSch(), (String)privateKeyPath, (String)publicKeyPath);
            return new SSHKeyPair(keyPair, privateKeyPath, publicKeyPath, SSHKeyType.getByJSchKeyType(keyPair));
        }
        catch (JSchException e) {
            throw new OpenShiftException(e, "Could not create new ssh key", new Object[0]);
        }
    }

    public String getPublicKey() {
        return Base64Coder.encode(this.keyPair.getPublicKeyBlob());
    }

    public String getPrivateKeyPath() {
        return this.privateKeyPath;
    }

    public String getPublicKeyPath() {
        return this.publicKeyPath;
    }
}

