/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.openshift.client.IOpenShiftResource;
import com.openshift.client.Message;
import com.openshift.client.Messages;
import com.openshift.client.OpenShiftException;
import com.openshift.client.OpenShiftRequestException;
import com.openshift.internal.client.IRestService;
import com.openshift.internal.client.ServiceParameter;
import com.openshift.internal.client.httpclient.IMediaType;
import com.openshift.internal.client.response.Link;
import com.openshift.internal.client.response.RestResponse;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOpenShiftResource
implements IOpenShiftResource {
    private Map<String, Link> links;
    private final IRestService service;
    private Messages messages;

    public AbstractOpenShiftResource(IRestService service) {
        this(service, null, null);
    }

    public AbstractOpenShiftResource(IRestService service, Map<String, Link> links, Messages messages) {
        this.service = service;
        this.links = links;
        this.messages = messages;
    }

    Map<String, Link> getLinks() throws OpenShiftException {
        return this.links;
    }

    void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    protected final IRestService getService() {
        return this.service;
    }

    protected Link getLink(String linkName) throws OpenShiftException {
        Link link = null;
        if (this.getLinks() != null) {
            link = this.getLinks().get(linkName);
        }
        if (link == null) {
            throw new OpenShiftRequestException("Could not find link \"{0}\" in resource \"{1}\"", linkName, this.getClass().getSimpleName());
        }
        return link;
    }

    protected boolean areLinksLoaded() {
        return this.links != null;
    }

    @Override
    public boolean hasCreationLog() {
        return this.messages.hasMessages();
    }

    @Override
    public String getCreationLog() {
        if (!this.hasCreationLog()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (Message message : this.messages.getAll()) {
            builder.append(message.getText());
        }
        return builder.toString();
    }

    @Override
    public Messages getMessages() {
        return this.messages;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ServiceRequest {
        private String linkName;

        protected ServiceRequest(String linkName) {
            this.linkName = linkName;
        }

        protected <DTO> DTO execute(ServiceParameter ... parameters) throws OpenShiftException {
            return this.execute(-1, parameters);
        }

        protected <DTO> DTO execute(int timeout, ServiceParameter ... parameters) throws OpenShiftException {
            Link link = AbstractOpenShiftResource.this.getLink(this.linkName);
            RestResponse response = AbstractOpenShiftResource.this.getService().request(link, timeout, parameters);
            if (response == null) {
                return null;
            }
            return (DTO)response.getData();
        }

        protected <DTO> DTO execute(int timeout, IMediaType mediaType, ServiceParameter ... parameters) throws OpenShiftException {
            Link link = AbstractOpenShiftResource.this.getLink(this.linkName);
            RestResponse response = AbstractOpenShiftResource.this.getService().request(link, timeout, mediaType, parameters);
            if (response == null) {
                return null;
            }
            return (DTO)response.getData();
        }
    }
}

