/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.openshift.client.IApplication;
import com.openshift.client.Message;
import com.openshift.client.Messages;
import com.openshift.client.OpenShiftException;
import com.openshift.client.cartridge.IEmbeddableCartridge;
import com.openshift.client.cartridge.IEmbeddedCartridge;
import com.openshift.internal.client.AbstractOpenShiftResource;
import com.openshift.internal.client.ApplicationResource;
import com.openshift.internal.client.CartridgeType;
import com.openshift.internal.client.ServiceParameter;
import com.openshift.internal.client.response.CartridgeResourceDTO;
import com.openshift.internal.client.response.Link;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedCartridgeResource
extends AbstractOpenShiftResource
implements IEmbeddedCartridge {
    private static final Pattern INFO_URL_PATTERN = Pattern.compile("URL: (.+)\\n*");
    private static final String LINK_DELETE_CARTRIDGE = "DELETE";
    private final String name;
    private final String displayName;
    private final String description;
    private final CartridgeType type;
    private String url;
    private final ApplicationResource application;

    protected EmbeddedCartridgeResource(String info, CartridgeResourceDTO dto, ApplicationResource application) {
        this(dto.getName(), dto.getDisplayName(), dto.getDescription(), dto.getType(), info, dto.getLinks(), dto.getMessages(), application);
    }

    protected EmbeddedCartridgeResource(String name, String displayName, String description, CartridgeType type, String info, Map<String, Link> links, Messages messages, ApplicationResource application) {
        super(application.getService(), links, messages);
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.type = type;
        this.url = this.extractUrl(info, this.getMessages());
        this.application = application;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    protected CartridgeType getType() {
        return this.type;
    }

    @Override
    public IApplication getApplication() {
        return this.application;
    }

    private String extractUrl(String info, Messages messages) {
        if (info != null) {
            return this.extractUrl(info);
        }
        return this.extractUrl(messages);
    }

    private String extractUrl(String string) {
        if (string == null) {
            return null;
        }
        Matcher matcher = INFO_URL_PATTERN.matcher(string);
        if (!matcher.find() || matcher.groupCount() < 1) {
            return null;
        }
        return matcher.group(1);
    }

    private String extractUrl(Messages messages) {
        if (messages == null) {
            return null;
        }
        for (Message message : messages.getAll()) {
            String url = this.extractUrl(message.getText());
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public String getUrl() throws OpenShiftException {
        return this.url;
    }

    @Override
    public void refresh() throws OpenShiftException {
    }

    @Override
    public void destroy() throws OpenShiftException {
        new DeleteCartridgeRequest().execute(new ServiceParameter[0]);
        this.application.removeEmbeddedCartridge(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!IEmbeddableCartridge.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        IEmbeddableCartridge other = (IEmbeddableCartridge)obj;
        return !(this.name == null ? other.getName() != null : !this.name.equals(other.getName()));
    }

    public String toString() {
        return "EmbeddedCartridgeResource [name=" + this.name + ", url=" + this.url + ", type=" + (Object)((Object)this.type) + ", url=" + this.url + ", application=" + this.application + "]";
    }

    private class DeleteCartridgeRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        protected DeleteCartridgeRequest() {
            super(EmbeddedCartridgeResource.LINK_DELETE_CARTRIDGE);
        }
    }
}

