/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client.httpclient;

import com.openshift.internal.client.httpclient.IMediaType;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormUrlEncodedMediaType
implements IMediaType {
    private static final String UTF8 = "UTF-8";

    @Override
    public String getType() {
        return "application/x-www-form-urlencoded";
    }

    @Override
    public String encodeParameters(Map<String, Object> parameters) throws UnsupportedEncodingException {
        return this.toUrlEncoded(parameters);
    }

    private String toUrlEncoded(Map<String, Object> parameters) throws UnsupportedEncodingException {
        if (parameters == null || parameters.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            this.append(entry.getKey(), URLEncoder.encode(String.valueOf(entry.getValue()), UTF8), builder);
        }
        return builder.toString();
    }

    private void append(String name, Object value, StringBuilder builder) {
        if (builder.length() > 0) {
            builder.append('&');
        }
        builder.append(name).append('=').append(value.toString());
    }
}

