/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.openshift.client.ApplicationScale;
import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.IGearProfile;
import com.openshift.client.IUser;
import com.openshift.client.Messages;
import com.openshift.client.OpenShiftException;
import com.openshift.client.cartridge.ICartridge;
import com.openshift.client.cartridge.IStandaloneCartridge;
import com.openshift.internal.client.APIResource;
import com.openshift.internal.client.AbstractOpenShiftResource;
import com.openshift.internal.client.ApplicationResource;
import com.openshift.internal.client.GearProfile;
import com.openshift.internal.client.ServiceParameter;
import com.openshift.internal.client.StandaloneCartridge;
import com.openshift.internal.client.httpclient.JsonMediaType;
import com.openshift.internal.client.response.ApplicationResourceDTO;
import com.openshift.internal.client.response.DomainResourceDTO;
import com.openshift.internal.client.response.Link;
import com.openshift.internal.client.response.LinkParameter;
import com.openshift.internal.client.utils.Assert;
import com.openshift.internal.client.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainResource
extends AbstractOpenShiftResource
implements IDomain {
    private static final String LINK_GET = "GET";
    private static final String LINK_LIST_APPLICATIONS = "LIST_APPLICATIONS";
    private static final String LINK_ADD_APPLICATION = "ADD_APPLICATION";
    private static final String LINK_UPDATE = "UPDATE";
    private static final String LINK_DELETE = "DELETE";
    private static final String URL_REGEX = "(https?|ftp)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
    private String id;
    private String suffix;
    private final APIResource connectionResource;
    private List<IApplication> applications = null;

    protected DomainResource(String namespace, String suffix, Map<String, Link> links, Messages messages, APIResource api) {
        super(api.getService(), links, messages);
        this.id = namespace;
        this.suffix = suffix;
        this.connectionResource = api;
    }

    protected DomainResource(DomainResourceDTO domainDTO, APIResource api) {
        this(domainDTO.getId(), domainDTO.getSuffix(), domainDTO.getLinks(), domainDTO.getMessages(), api);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public void rename(String id) throws OpenShiftException {
        Assert.notNull(id);
        DomainResourceDTO domainDTO = new UpdateDomainRequest().execute(id);
        this.id = domainDTO.getId();
        this.suffix = domainDTO.getSuffix();
        this.getLinks().clear();
        this.getLinks().putAll(domainDTO.getLinks());
    }

    @Override
    public IUser getUser() throws OpenShiftException {
        return this.connectionResource.getUser();
    }

    @Override
    public boolean waitForAccessible(long timeout) throws OpenShiftException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IApplication createApplication(String name, IStandaloneCartridge cartridge) throws OpenShiftException {
        return this.createApplication(name, cartridge, (String)null);
    }

    @Override
    public IApplication createApplication(String name, IStandaloneCartridge cartridge, ApplicationScale scale) throws OpenShiftException {
        return this.createApplication(name, cartridge, scale, null, null);
    }

    @Override
    public IApplication createApplication(String name, IStandaloneCartridge cartridge, String initialGitUrl) throws OpenShiftException {
        return this.createApplication(name, cartridge, null, null, initialGitUrl);
    }

    public IApplication createApplication(String name, IStandaloneCartridge cartridge, ApplicationScale scale, String initialGitUrl) throws OpenShiftException {
        return this.createApplication(name, cartridge, scale, null, initialGitUrl);
    }

    @Override
    public IApplication createApplication(String name, IStandaloneCartridge cartridge, IGearProfile gearProfile) throws OpenShiftException {
        return this.createApplication(name, cartridge, null, gearProfile);
    }

    public IApplication createApplication(String name, IStandaloneCartridge cartridge, IGearProfile gearProfile, String initialGitUrl) throws OpenShiftException {
        return this.createApplication(name, cartridge, null, gearProfile, initialGitUrl);
    }

    @Override
    public IApplication createApplication(String name, IStandaloneCartridge cartridge, ApplicationScale scale, IGearProfile gearProfile) throws OpenShiftException {
        return this.createApplication(name, cartridge, scale, gearProfile, null);
    }

    @Override
    public IApplication createApplication(String name, IStandaloneCartridge cartridge, ApplicationScale scale, IGearProfile gearProfile, String initialGitUrl) throws OpenShiftException {
        return this.createApplication(name, cartridge, scale, gearProfile, initialGitUrl, -1);
    }

    @Override
    public IApplication createApplication(String name, IStandaloneCartridge cartridge, ApplicationScale scale, IGearProfile gearProfile, String initialGitUrl, int timeout) {
        return this.createApplication(name, cartridge, scale, gearProfile, initialGitUrl, timeout, null);
    }

    @Override
    public IApplication createApplication(String name, IStandaloneCartridge cartridge, ApplicationScale scale, IGearProfile gearProfile, String initialGitUrl, int timeout, Map<String, String> userEnvVars) throws OpenShiftException {
        if (name == null) {
            throw new OpenShiftException("Application name is mandatory but none was given.", new Object[0]);
        }
        if (this.hasApplicationByName(name)) {
            throw new OpenShiftException("Application with name \"{0}\" already exists.", name);
        }
        ApplicationResourceDTO applicationDTO = new CreateApplicationRequest().execute(name, cartridge, scale, gearProfile, initialGitUrl, timeout, userEnvVars);
        ApplicationResource application = new ApplicationResource(applicationDTO, cartridge, this);
        this.getOrLoadApplications().add(application);
        return application;
    }

    @Override
    public IApplication createApplication(String name, IStandaloneCartridge cartridge, ApplicationScale scale, IGearProfile gearProfile, String initialGitUrl, long timeout) throws OpenShiftException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasApplicationByName(String name) throws OpenShiftException {
        return this.getApplicationByName(name) != null;
    }

    @Override
    public IApplication getApplicationByName(String name) throws OpenShiftException {
        Assert.notNull(name);
        return this.getApplicationByName(name, this.getApplications());
    }

    private IApplication getApplicationByName(String name, Collection<IApplication> applications) throws OpenShiftException {
        Assert.notNull(name);
        IApplication matchingApplication = null;
        for (IApplication application : applications) {
            if (!application.getName().equalsIgnoreCase(name)) continue;
            matchingApplication = application;
            break;
        }
        return matchingApplication;
    }

    @Override
    public List<IApplication> getApplicationsByCartridge(IStandaloneCartridge cartridge) throws OpenShiftException {
        ArrayList<IApplication> matchingApplications = new ArrayList<IApplication>();
        for (IApplication application : this.getApplications()) {
            if (!cartridge.equals(application.getCartridge())) continue;
            matchingApplications.add(application);
        }
        return matchingApplications;
    }

    @Override
    public boolean hasApplicationByCartridge(IStandaloneCartridge cartridge) throws OpenShiftException {
        return this.getApplicationsByCartridge(cartridge).size() > 0;
    }

    @Override
    public void destroy() throws OpenShiftException {
        this.destroy(false);
    }

    @Override
    public void destroy(boolean force) throws OpenShiftException {
        new DeleteDomainRequest().execute(force);
        this.connectionResource.removeDomain(this);
    }

    protected List<IApplication> getOrLoadApplications() throws OpenShiftException {
        if (this.applications == null) {
            this.applications = this.loadApplications();
        }
        return this.applications;
    }

    @Override
    public List<IApplication> getApplications() throws OpenShiftException {
        return CollectionUtils.toUnmodifiableCopy(this.getOrLoadApplications());
    }

    private List<IApplication> loadApplications() throws OpenShiftException {
        ArrayList<IApplication> apps = new ArrayList<IApplication>();
        List applicationDTOs = (List)new ListApplicationsRequest().execute(new ServiceParameter[0]);
        for (ApplicationResourceDTO applicationDTO : applicationDTOs) {
            StandaloneCartridge cartridge = new StandaloneCartridge(applicationDTO.getFramework());
            ApplicationResource application = new ApplicationResource(applicationDTO, cartridge, this);
            apps.add(application);
        }
        return apps;
    }

    protected void removeApplication(IApplication application) {
        this.applications.remove(application);
    }

    @Override
    public List<String> getAvailableCartridgeNames() throws OpenShiftException {
        ArrayList<String> cartridges = new ArrayList<String>();
        for (LinkParameter param : this.getLink(LINK_ADD_APPLICATION).getRequiredParams()) {
            if (!param.getName().equals("cartridge")) continue;
            for (String option : param.getValidOptions()) {
                cartridges.add(option);
            }
        }
        return cartridges;
    }

    @Override
    public List<IGearProfile> getAvailableGearProfiles() throws OpenShiftException {
        ArrayList<IGearProfile> gearSizes = new ArrayList<IGearProfile>();
        for (LinkParameter param : this.getLink(LINK_ADD_APPLICATION).getOptionalParams()) {
            if (!param.getName().equals("gear_profile")) continue;
            for (String option : param.getValidOptions()) {
                gearSizes.add(new GearProfile(option));
            }
        }
        return gearSizes;
    }

    @Override
    public void refresh() throws OpenShiftException {
        DomainResourceDTO domainResourceDTO = new GetDomainRequest().execute();
        this.id = domainResourceDTO.getId();
        this.suffix = domainResourceDTO.getSuffix();
        if (this.applications != null) {
            this.applications = this.loadApplications();
        }
    }

    public String toString() {
        return "Domain [id=" + this.id + ", " + "suffix=" + this.suffix + "]";
    }

    private class DeleteDomainRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        public DeleteDomainRequest() throws OpenShiftException {
            super(DomainResource.LINK_DELETE);
        }

        public void execute(boolean force) throws OpenShiftException {
            super.execute(new ServiceParameter("force", force));
        }
    }

    private class UpdateDomainRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        public UpdateDomainRequest() throws OpenShiftException {
            super(DomainResource.LINK_UPDATE);
        }

        public DomainResourceDTO execute(String namespace) throws OpenShiftException {
            return (DomainResourceDTO)super.execute(new ServiceParameter("id", namespace));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CreateApplicationRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        public CreateApplicationRequest() throws OpenShiftException {
            super(DomainResource.LINK_ADD_APPLICATION);
        }

        public ApplicationResourceDTO execute(String name, IStandaloneCartridge cartridge, ApplicationScale scale, IGearProfile gearProfile, String initialGitUrl, int timeout, Map<String, String> userEnvVars) throws OpenShiftException {
            if (cartridge == null) {
                throw new OpenShiftException("Application cartridge is mandatory but was not given.", new Object[0]);
            }
            ArrayList<ServiceParameter> parameters = new ArrayList<ServiceParameter>();
            this.addStringParameter("name", name, parameters);
            this.addCartridgeParameter(cartridge, parameters);
            this.addScaleParameter(scale, parameters);
            this.addGearProfileParameter(gearProfile, parameters);
            this.addStringParameter("initial_git_url", initialGitUrl, parameters);
            this.addListOfNameValuePairs("environment_variables", userEnvVars, parameters);
            if (this.isDownloadableCartridge(cartridge)) {
                return (ApplicationResourceDTO)super.execute(timeout, new JsonMediaType(), parameters.toArray(new ServiceParameter[parameters.size()]));
            }
            return (ApplicationResourceDTO)super.execute(timeout, parameters.toArray(new ServiceParameter[parameters.size()]));
        }

        private List<ServiceParameter> addCartridgeParameter(IStandaloneCartridge cartridge, List<ServiceParameter> parameters) {
            if (cartridge == null) {
                return parameters;
            }
            if (this.isDownloadableCartridge(cartridge)) {
                HashMap<String, String> props = new HashMap<String, String>();
                props.put("url", cartridge.getName());
                parameters.add(new ServiceParameter("cartridges", Arrays.asList(props)));
            } else {
                parameters.add(new ServiceParameter("cartridge", cartridge.getName()));
            }
            return parameters;
        }

        private List<ServiceParameter> addScaleParameter(ApplicationScale scale, List<ServiceParameter> parameters) {
            if (scale == null) {
                return parameters;
            }
            parameters.add(new ServiceParameter("scale", scale.getValue()));
            return parameters;
        }

        private List<ServiceParameter> addGearProfileParameter(IGearProfile gearProfile, List<ServiceParameter> parameters) {
            if (gearProfile == null) {
                return parameters;
            }
            parameters.add(new ServiceParameter("gear_profile", gearProfile.getName()));
            return parameters;
        }

        private List<ServiceParameter> addStringParameter(String parameterName, String value, List<ServiceParameter> parameters) {
            if (value == null) {
                return parameters;
            }
            parameters.add(new ServiceParameter(parameterName, value));
            return parameters;
        }

        private List<ServiceParameter> addListOfNameValuePairs(String parameterName, Map<String, String> value, List<ServiceParameter> parameters) {
            if (value == null) {
                return parameters;
            }
            Set<Map.Entry<String, String>> entries = value.entrySet();
            ArrayList listOfNameValuePairs = new ArrayList();
            for (Map.Entry<String, String> entry : entries) {
                HashMap<String, String> envVar = new HashMap<String, String>();
                envVar.put("name", entry.getKey());
                envVar.put("value", entry.getValue());
                listOfNameValuePairs.add(envVar);
            }
            parameters.add(new ServiceParameter(parameterName, listOfNameValuePairs));
            return parameters;
        }

        private boolean isDownloadableCartridge(ICartridge cartridge) {
            return cartridge.getName().matches(DomainResource.URL_REGEX);
        }
    }

    private class ListApplicationsRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        public ListApplicationsRequest() throws OpenShiftException {
            super(DomainResource.LINK_LIST_APPLICATIONS);
        }
    }

    private class GetDomainRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        public GetDomainRequest() throws OpenShiftException {
            super(DomainResource.LINK_GET);
        }

        protected DomainResourceDTO execute() throws OpenShiftException {
            return (DomainResourceDTO)super.execute(new ServiceParameter[0]);
        }
    }
}

