/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client.httpclient;

import com.openshift.client.HttpMethod;
import com.openshift.client.IHttpClient;
import com.openshift.client.utils.Base64Coder;
import com.openshift.internal.client.httpclient.BadRequestException;
import com.openshift.internal.client.httpclient.EncodingException;
import com.openshift.internal.client.httpclient.HttpClientException;
import com.openshift.internal.client.httpclient.IMediaType;
import com.openshift.internal.client.httpclient.InternalServerErrorException;
import com.openshift.internal.client.httpclient.NotFoundException;
import com.openshift.internal.client.httpclient.UnauthorizedException;
import com.openshift.internal.client.utils.StreamUtils;
import com.openshift.internal.client.utils.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlConnectionHttpClient
implements IHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(UrlConnectionHttpClient.class);
    private static final String SYSPROP_OPENSHIFT_CONNECT_TIMEOUT = "com.openshift.httpclient.timeout";
    private static final String SYSPROP_DEFAULT_CONNECT_TIMEOUT = "sun.net.client.defaultConnectTimeout";
    private static final String SYSPROP_DEFAULT_READ_TIMEOUT = "sun.net.client.defaultReadTimeout";
    private static final String USERAGENT_FOR_KEYAUTH = "OpenShift";
    private String userAgent;
    private boolean sslChecks;
    private String username;
    private String password;
    private String authKey;
    private String authIV;
    private IMediaType requestMediaType;
    private String acceptedMediaType;
    private String acceptVersion;

    public UrlConnectionHttpClient(String username, String password, String userAgent, boolean sslChecks, IMediaType requestMediaType, String acceptedMediaType, String version) {
        this(username, password, userAgent, sslChecks, requestMediaType, acceptedMediaType, version, null, null);
    }

    public UrlConnectionHttpClient(String username, String password, String userAgent, boolean sslChecks, IMediaType requestMediaType, String acceptedMediaType, String version, String authKey, String authIV) {
        this.username = username;
        this.password = password;
        this.userAgent = this.setupUserAgent(authKey, authIV, userAgent);
        this.sslChecks = sslChecks;
        this.requestMediaType = requestMediaType;
        this.acceptedMediaType = acceptedMediaType;
        this.authKey = authKey;
        this.authIV = authIV;
        this.acceptVersion = version;
    }

    private String setupUserAgent(String authKey, String authIV, String userAgent) {
        if (!StringUtils.isEmpty(authKey)) {
            if (userAgent == null) {
                userAgent = USERAGENT_FOR_KEYAUTH;
            } else if (!userAgent.startsWith(USERAGENT_FOR_KEYAUTH)) {
                userAgent = "OpenShift-" + userAgent;
            }
        }
        return userAgent;
    }

    @Override
    public void setAcceptedMediaType(String acceptedMediaType) {
        this.acceptedMediaType = acceptedMediaType;
    }

    @Override
    public String getAcceptedMediaType() {
        return this.acceptedMediaType;
    }

    @Override
    public String get(URL url) throws HttpClientException, SocketTimeoutException {
        return this.get(url, -1);
    }

    @Override
    public String get(URL url, int timeout) throws HttpClientException, SocketTimeoutException {
        HttpURLConnection connection = null;
        try {
            String string = this.write(null, HttpMethod.GET.toString(), url, timeout, this.requestMediaType);
            return string;
        }
        catch (SocketTimeoutException e) {
            throw e;
        }
        catch (IOException e) {
            throw this.createException(e, connection);
        }
        finally {
            this.disconnect(connection);
        }
    }

    @Override
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public void setAcceptVersion(String version) {
        this.acceptVersion = version;
    }

    @Override
    public String getAcceptVersion() {
        return this.acceptVersion;
    }

    @Override
    public IMediaType getRequestMediaType() {
        return this.requestMediaType;
    }

    @Override
    public void setRequestMediaType(IMediaType requestMediaType) {
        this.requestMediaType = requestMediaType;
    }

    @Override
    public String put(Map<String, Object> parameters, URL url) throws SocketTimeoutException, EncodingException, HttpClientException {
        return this.put(this.requestMediaType.encodeParameters(parameters), url);
    }

    @Override
    public String put(Map<String, Object> parameters, URL url, int timeout) throws HttpClientException, SocketTimeoutException, EncodingException {
        return this.put(parameters, url, timeout, this.requestMediaType);
    }

    @Override
    public String put(Map<String, Object> parameters, URL url, int timeout, IMediaType mediaType) throws HttpClientException, SocketTimeoutException, EncodingException {
        return this.write(mediaType.encodeParameters(parameters), HttpMethod.PUT.toString(), url, timeout, mediaType);
    }

    protected String put(String data, URL url) throws HttpClientException, SocketTimeoutException {
        return this.write(data, HttpMethod.PUT.toString(), url, -1, this.requestMediaType);
    }

    @Override
    public String post(Map<String, Object> parameters, URL url) throws SocketTimeoutException, EncodingException, HttpClientException {
        return this.post(this.requestMediaType.encodeParameters(parameters), url);
    }

    protected String post(String data, URL url) throws HttpClientException, SocketTimeoutException {
        return this.write(data, HttpMethod.POST.toString(), url, -1, this.requestMediaType);
    }

    @Override
    public String post(Map<String, Object> data, URL url, int timeout) throws HttpClientException, SocketTimeoutException, EncodingException {
        return this.post(data, url, timeout, this.requestMediaType);
    }

    @Override
    public String post(Map<String, Object> parameters, URL url, int timeout, IMediaType mediaType) throws HttpClientException, SocketTimeoutException, EncodingException {
        return this.write(mediaType.encodeParameters(parameters), HttpMethod.POST.toString(), url, timeout, mediaType);
    }

    @Override
    public String delete(Map<String, Object> parameters, URL url) throws HttpClientException, SocketTimeoutException, EncodingException {
        return this.delete(this.requestMediaType.encodeParameters(parameters), url);
    }

    @Override
    public String delete(Map<String, Object> parameters, URL url, int timeout) throws HttpClientException, SocketTimeoutException, EncodingException {
        return this.delete(parameters, url, timeout, this.requestMediaType);
    }

    @Override
    public String delete(Map<String, Object> parameters, URL url, int timeout, IMediaType mediaType) throws HttpClientException, SocketTimeoutException, EncodingException {
        return this.write(mediaType.encodeParameters(parameters), HttpMethod.DELETE.toString(), url, timeout, mediaType);
    }

    @Override
    public String delete(URL url) throws HttpClientException, SocketTimeoutException, UnsupportedEncodingException {
        return this.delete((String)null, url);
    }

    protected String delete(String data, URL url) throws HttpClientException, SocketTimeoutException {
        return this.write(data, HttpMethod.DELETE.toString(), url, -1, this.requestMediaType);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String write(String data, String requestMethod, URL url, int timeout, IMediaType mediaType) throws SocketTimeoutException, HttpClientException {
        HttpURLConnection connection = null;
        try {
            connection = this.createConnection(this.username, this.password, this.authKey, this.authIV, this.userAgent, url, timeout, mediaType);
            connection.setRequestMethod(requestMethod);
            connection.setDoOutput(true);
            if (data != null) {
                LOGGER.trace("Sending \"{}\" to {}", (Object)data, (Object)url);
                StreamUtils.writeTo(data.getBytes(), connection.getOutputStream());
            }
            String string = StreamUtils.readToString(connection.getInputStream());
            this.disconnect(connection);
            return string;
        }
        catch (SocketTimeoutException e) {
            try {
                throw e;
                catch (IOException e2) {
                    throw this.createException(e2, connection);
                }
            }
            catch (Throwable throwable) {
                this.disconnect(connection);
                throw throwable;
            }
        }
    }

    private void disconnect(HttpURLConnection connection) {
        if (connection != null) {
            connection.disconnect();
        }
    }

    private HttpClientException createException(IOException ioe, HttpURLConnection connection) throws SocketTimeoutException {
        try {
            int responseCode = connection.getResponseCode();
            String errorMessage = this.createErrorMessage(ioe, connection);
            switch (responseCode) {
                case 500: {
                    return new InternalServerErrorException(errorMessage, ioe);
                }
                case 400: {
                    return new BadRequestException(errorMessage, ioe);
                }
                case 401: {
                    return new UnauthorizedException(errorMessage, ioe);
                }
                case 404: {
                    return new NotFoundException(errorMessage, ioe);
                }
            }
            return new HttpClientException(errorMessage, ioe);
        }
        catch (SocketTimeoutException e) {
            throw e;
        }
        catch (IOException e) {
            return new HttpClientException(e);
        }
    }

    protected String createErrorMessage(IOException ioe, HttpURLConnection connection) throws IOException {
        String errorMessage = StreamUtils.readToString(connection.getErrorStream());
        if (!StringUtils.isEmpty(errorMessage)) {
            return errorMessage;
        }
        StringBuilder builder = new StringBuilder("Connection to ").append(connection.getURL());
        String reason = connection.getResponseMessage();
        if (!StringUtils.isEmpty(reason)) {
            builder.append(": ").append(reason);
        }
        return builder.toString();
    }

    private boolean isHttps(URL url) {
        return "https".equals(url.getProtocol());
    }

    private void setPermissiveSSLSocketFactory(HttpsURLConnection connection) {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(new KeyManager[0], new TrustManager[]{new PermissiveTrustManager()}, new SecureRandom());
            SSLSocketFactory socketFactory = sslContext.getSocketFactory();
            connection.setSSLSocketFactory(socketFactory);
        }
        catch (KeyManagementException e) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    protected HttpURLConnection createConnection(String username, String password, String userAgent, URL url) throws IOException {
        return this.createConnection(username, password, null, null, userAgent, url, -1, this.requestMediaType);
    }

    protected HttpURLConnection createConnection(String username, String password, String authKey, String authIV, String userAgent, URL url, int timeout, IMediaType mediaType) throws IOException {
        LOGGER.trace("creating connection to {} using username \"{}\" and password \"{}\"", new Object[]{url, username, password});
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        this.setSSLChecks(url, connection);
        this.setAuthorisation(username, password, authKey, authIV, connection);
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setAllowUserInteraction(false);
        this.setConnectTimeout(connection);
        this.setReadTimeout(timeout, connection);
        connection.setInstanceFollowRedirects(true);
        this.setAcceptHeader(connection);
        this.setUserAgent(connection);
        connection.setRequestProperty("Content-Type", mediaType.getType());
        return connection;
    }

    private void setUserAgent(HttpURLConnection connection) {
        String userAgent = this.userAgent;
        if (!StringUtils.isEmpty(this.authKey)) {
            userAgent = USERAGENT_FOR_KEYAUTH;
        }
        if (userAgent != null) {
            connection.setRequestProperty("User-Agent", userAgent);
        }
    }

    private void setAcceptHeader(HttpURLConnection connection) {
        StringBuilder builder = new StringBuilder(this.acceptedMediaType);
        if (this.acceptVersion != null) {
            builder.append(';').append(' ').append("version").append('=').append(this.acceptVersion);
        }
        connection.setRequestProperty("Accept", builder.toString());
    }

    private void setAuthorisation(String username, String password, String authKey, String authIV, HttpURLConnection connection) {
        if (username == null || username.trim().length() == 0 || password == null || password.trim().length() == 0) {
            if (authKey != null && authIV != null) {
                connection.setRequestProperty("broker_auth_key", authKey);
                connection.setRequestProperty("broker_auth_iv", authIV);
            }
        } else {
            String credentials = Base64Coder.encode((username + ':' + password).getBytes());
            connection.setRequestProperty("Authorization", "Basic" + ' ' + credentials);
        }
    }

    private void setSSLChecks(URL url, HttpURLConnection connection) {
        if (this.isHttps(url) && !this.sslChecks) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
            httpsConnection.setHostnameVerifier(new NoopHostnameVerifier());
            this.setPermissiveSSLSocketFactory(httpsConnection);
        }
    }

    private void setConnectTimeout(URLConnection connection) {
        int timeout = this.getTimeout(this.getSystemPropertyInteger(SYSPROP_OPENSHIFT_CONNECT_TIMEOUT), this.getSystemPropertyInteger(SYSPROP_DEFAULT_CONNECT_TIMEOUT), 10000);
        connection.setConnectTimeout(timeout);
    }

    private void setReadTimeout(int timeout, URLConnection connection) {
        timeout = this.getTimeout(timeout, this.getSystemPropertyInteger(SYSPROP_DEFAULT_READ_TIMEOUT), 120000);
        connection.setReadTimeout(timeout);
    }

    private int getTimeout(int timeout, int systemPropertyTimeout, int defaultTimeout) {
        if (timeout == -1 && (timeout = systemPropertyTimeout) == -1) {
            timeout = defaultTimeout;
        }
        return timeout;
    }

    private int getSystemPropertyInteger(String key) {
        try {
            return Integer.parseInt(System.getProperty(key));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private class NoopHostnameVerifier
    implements HostnameVerifier {
        private NoopHostnameVerifier() {
        }

        public boolean verify(String hostname, SSLSession sslSession) {
            return true;
        }
    }

    private class PermissiveTrustManager
    implements X509TrustManager {
        private PermissiveTrustManager() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

