/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.api.jmx;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.ContainerProvider;
import org.fusesource.fabric.api.CreateContainerMetadata;
import org.fusesource.fabric.api.CreateContainerOptions;
import org.fusesource.fabric.api.FabricRequirements;
import org.fusesource.fabric.api.FabricStatus;
import org.fusesource.fabric.api.Ids;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.api.jmx.ContainerDTO;
import org.fusesource.fabric.api.jmx.FabricManagerMBean;
import org.fusesource.fabric.api.jmx.ProfileDTO;
import org.fusesource.fabric.api.jmx.VersionDTO;
import org.fusesource.fabric.service.FabricServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricManager
implements FabricManagerMBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(FabricManager.class);
    private final FabricServiceImpl fabricService;
    private ObjectName objectName;

    public FabricManager(FabricServiceImpl fabricService) {
        this.fabricService = fabricService;
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        if (this.objectName == null) {
            this.objectName = new ObjectName("org.fusesource.fabric:type=Fabric");
        }
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public void registerMBeanServer(MBeanServer mbeanServer) {
        try {
            ObjectName name = this.getObjectName();
            if (!mbeanServer.isRegistered(name)) {
                mbeanServer.registerMBean(this, name);
            }
        }
        catch (Exception e) {
            LOG.warn("An error occured during mbean server registration: " + e, (Throwable)e);
        }
    }

    public void unregisterMBeanServer(MBeanServer mbeanServer) {
        if (mbeanServer != null) {
            try {
                ObjectName name = this.getObjectName();
                if (mbeanServer.isRegistered(name)) {
                    mbeanServer.unregisterMBean(name);
                }
            }
            catch (Exception e) {
                LOG.warn("An error occured during mbean server registration: " + e, (Throwable)e);
            }
        }
    }

    protected FabricServiceImpl getFabricService() {
        return this.fabricService;
    }

    @Override
    public CreateContainerMetadata[] createContainers(CreateContainerOptions options) {
        return this.getFabricService().createContainers(options);
    }

    @Override
    public ProfileDTO createProfile(String version, String name) {
        return ProfileDTO.newInstance(this.getFabricService(), this.getFabricService().createProfile(version, name));
    }

    @Override
    public VersionDTO createVersion(String parentVersionId, String toVersion) {
        return VersionDTO.newInstance(this.getFabricService().createVersion(parentVersionId, toVersion));
    }

    @Override
    public VersionDTO createVersion(String version) {
        return VersionDTO.newInstance(this.getFabricService().createVersion(version));
    }

    @Override
    public void deleteProfile(String versionId, String profileId) {
        this.getFabricService().deleteProfile(versionId, profileId);
    }

    @Override
    public void deleteVersion(String version) {
        this.getFabricService().deleteVersion(version);
    }

    @Override
    public void destroyContainer(String containerId) {
        this.getFabricService().destroyContainer(containerId);
    }

    @Override
    public ContainerDTO getContainer(String name) {
        return ContainerDTO.newInstance(this.getFabricService().getContainer(name));
    }

    @Override
    public List<String> getContainerProvisionList(String name) {
        Container container = this.getFabricService().getContainer(name);
        if (container != null) {
            return new ArrayList<String>();
        }
        throw new IllegalStateException(String.format("Container %s not found.", name));
    }

    private Profile[] getProfiles(Version version, List<String> names) {
        ArrayList<Profile> answer = new ArrayList<Profile>();
        for (String name : names) {
            answer.add(version.getProfile(name));
        }
        return answer.toArray(new Profile[answer.size()]);
    }

    @Override
    public void addProfilesToContainer(String container, List<String> profiles) {
        Container cont = this.getFabricService().getContainer(container);
        Profile[] existing = cont.getProfiles();
        if (existing != null) {
            for (Profile p : existing) {
                if (profiles.contains(p.getId())) continue;
                profiles.add(p.getId());
            }
        }
        cont.setProfiles(this.getProfiles(cont.getVersion(), profiles));
    }

    @Override
    public void removeProfilesFromContainer(String container, List<String> profiles) {
        Container cont = this.getFabricService().getContainer(container);
        Profile[] existing = cont.getProfiles();
        ArrayList<String> updated = new ArrayList<String>();
        if (existing != null) {
            for (Profile p : existing) {
                if (profiles.contains(p.getId())) continue;
                updated.add(p.getId());
            }
        }
        cont.setProfiles(this.getProfiles(cont.getVersion(), updated));
    }

    @Override
    public List<ContainerDTO> containers() {
        return ContainerDTO.newInstances(this.getFabricService().getContainers());
    }

    @Override
    public String[] containerIds() {
        ArrayList<String> answer = new ArrayList<String>();
        for (Container container : this.getFabricService().getContainers()) {
            answer.add(container.getId());
        }
        return answer.toArray(new String[answer.size()]);
    }

    @Override
    public List<String> containerIdsForProfile(String versionId, String profileId) {
        Profile profile = this.getFabricService().getProfile(versionId, profileId);
        if (profile != null) {
            return new ArrayList<String>();
        }
        throw new IllegalStateException(String.format("Profile %s not found.", profileId));
    }

    @Override
    public List<ContainerDTO> containersForProfile(String versionId, String profileId) {
        Profile profile = this.getFabricService().getProfile(versionId, profileId);
        if (profile != null) {
            return new ArrayList<ContainerDTO>();
        }
        throw new IllegalStateException(String.format("Profile %s not found.", profileId));
    }

    @Override
    public ContainerDTO currentContainer() {
        return ContainerDTO.newInstance(this.getFabricService().getCurrentContainer());
    }

    @Override
    public String getCurrentContainerName() {
        return this.getFabricService().getCurrentContainerName();
    }

    @Override
    public String getDefaultJvmOptions() {
        return this.getFabricService().getDefaultJvmOptions();
    }

    @Override
    public String getDefaultRepo() {
        return this.getFabricService().getDefaultRepo();
    }

    @Override
    public VersionDTO defaultVersion() {
        return VersionDTO.newInstance(this.getFabricService().getDefaultVersion());
    }

    @Override
    public FabricStatus fabricStatus() {
        return this.getFabricService().getFabricStatus();
    }

    @Override
    public String getMavenRepoUploadURI() {
        URI answer = this.getFabricService().getMavenRepoUploadURI();
        return answer != null ? answer.toString() : null;
    }

    @Override
    public String getMavenRepoURI() {
        URI answer = this.getFabricService().getMavenRepoURI();
        return answer != null ? answer.toString() : null;
    }

    @Override
    public ProfileDTO getProfile(String version, String name) {
        return ProfileDTO.newInstance(this.getFabricService(), this.getFabricService().getProfile(version, name));
    }

    @Override
    public List<ProfileDTO> getProfiles(String version) {
        return ProfileDTO.newInstances(this.getFabricService(), this.getFabricService().getProfiles(version));
    }

    @Override
    public List<String> getProfileIds(String version) {
        return Ids.getIds(this.getFabricService().getProfiles(version));
    }

    @Override
    public byte[] getConfigurationFile(String versionId, String profileId, String fileName) {
        return this.getFabricService().getVersion(versionId).getProfile(profileId).getFileConfigurations().get(fileName);
    }

    @Override
    public void deleteConfigurationFile(String versionId, String profileId, String fileName) {
        Profile profile = this.getFabricService().getVersion(versionId).getProfile(profileId);
        Map<String, byte[]> configs = profile.getFileConfigurations();
        configs.remove(fileName);
        profile.setFileConfigurations(configs);
    }

    @Override
    public void setConfigurationFile(String versionId, String profileId, String fileName, byte[] data) {
        Profile profile = this.getFabricService().getVersion(versionId).getProfile(profileId);
        Map<String, byte[]> configs = profile.getFileConfigurations();
        configs.put(fileName, data);
        profile.setFileConfigurations(configs);
    }

    @Override
    public FabricRequirements requirements() {
        return this.getFabricService().getRequirements();
    }

    @Override
    public VersionDTO getVersion(String name) {
        return VersionDTO.newInstance(this.getFabricService().getVersion(name));
    }

    @Override
    public List<VersionDTO> versions() {
        String defaultVersionId = null;
        Version defaultVersion = this.getFabricService().getDefaultVersion();
        if (defaultVersion != null) {
            defaultVersionId = defaultVersion.getName();
        }
        List<VersionDTO> answer = VersionDTO.newInstances(this.getFabricService().getVersions());
        for (VersionDTO versionDTO : answer) {
            if (defaultVersionId != null && !defaultVersionId.equals(versionDTO.getId())) continue;
            versionDTO.setDefaultVersion(true);
            break;
        }
        return answer;
    }

    @Override
    public String getZookeeperInfo(String name) {
        return this.getFabricService().getZookeeperInfo(name);
    }

    @Override
    public String getZookeeperUrl() {
        return this.getFabricService().getZookeeperUrl();
    }

    @Override
    public void registerProvider(ContainerProvider provider, Map<String, Object> properties) {
        this.getFabricService().registerProvider(provider, properties);
    }

    @Override
    public void registerProvider(String scheme, ContainerProvider provider) {
        this.getFabricService().registerProvider(scheme, provider);
    }

    @Override
    public void setDefaultJvmOptions(String jvmOptions) {
        this.getFabricService().setDefaultJvmOptions(jvmOptions);
    }

    @Override
    public void setDefaultRepo(String defaultRepo) {
        this.getFabricService().setDefaultRepo(defaultRepo);
    }

    @Override
    public void setDefaultVersion(String versionId) {
        this.getFabricService().setDefaultVersion(versionId);
    }

    @Override
    public void requirements(FabricRequirements requirements) throws IOException {
        this.getFabricService().setRequirements(requirements);
    }

    @Override
    public void startContainer(String containerId) {
        this.getFabricService().startContainer(containerId);
    }

    @Override
    public void stopContainer(String containerId) {
        this.getFabricService().stopContainer(containerId);
    }

    @Override
    public void unregisterProvider(ContainerProvider provider, Map<String, Object> properties) {
        this.getFabricService().unregisterProvider(provider, properties);
    }

    @Override
    public void unregisterProvider(String scheme) {
        this.getFabricService().unregisterProvider(scheme);
    }
}

