/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.internal;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.fusesource.fabric.api.CreateContainerMetadata;
import org.fusesource.fabric.api.CreateJCloudsContainerOptions;
import org.fusesource.fabric.api.CreateRemoteContainerOptions;
import org.fusesource.fabric.internal.FabricConstants;
import org.fusesource.fabric.utils.Base64Encoder;
import org.fusesource.fabric.utils.ObjectUtils;
import org.fusesource.fabric.utils.Ports;

public final class ContainerProviderUtils {
    public static final String FAILURE_PREFIX = "Command Failed:";
    public static final String RESOLVER_OVERRIDE = "RESOLVER OVERRIDE:";
    public static final String ADDRESSES_PROPERTY_KEY = "addresses";
    private static final String LINE_APPEND = "sed  's/%s/&%s/' %s > %s";
    private static final String FIRST_FABRIC_DIRECTORY = "ls -l | grep fuse-fabric | grep ^d | awk '{ print $NF }' | sort -n | head -1";
    private static final String RUN_FUNCTION = ContainerProviderUtils.loadFunction("run.sh");
    private static final String DOWNLOAD_FUNCTION = ContainerProviderUtils.loadFunction("download.sh");
    private static final String MAVEN_DOWNLOAD_FUNCTION = ContainerProviderUtils.loadFunction("maven_download.sh");
    private static final String INSTALL_JDK = ContainerProviderUtils.loadFunction("install_open_jdk.sh");
    private static final String INSTALL_CURL = ContainerProviderUtils.loadFunction("install_curl.sh");
    private static final String INSTALL_UNZIP = ContainerProviderUtils.loadFunction("install_unzip.sh");
    private static final String UPDATE_PKGS = ContainerProviderUtils.loadFunction("update_pkgs.sh");
    private static final String VALIDATE_REQUIREMENTS = ContainerProviderUtils.loadFunction("validate_requirements.sh");
    private static final String EXIT_IF_NOT_EXISTS = ContainerProviderUtils.loadFunction("exit_if_not_exists.sh");
    private static final String COPY_NODE_METADATA = ContainerProviderUtils.loadFunction("copy_node_metadata.sh");
    private static final String KARAF_CHECK = ContainerProviderUtils.loadFunction("karaf_check.sh");
    private static final String KARAF_KILL = ContainerProviderUtils.loadFunction("karaf_kill.sh");
    private static final String REPLACE_IN_FILE = ContainerProviderUtils.loadFunction("replace_in_file.sh");
    private static final String CONFIGURE_HOSTNAMES = ContainerProviderUtils.loadFunction("configure_hostname.sh");
    private static final String FIND_FREE_PORT = ContainerProviderUtils.loadFunction("find_free_port.sh");
    private static final String WAIT_FOR_PORT = ContainerProviderUtils.loadFunction("wait_for_port.sh");
    public static final int DEFAULT_SSH_PORT = 8101;
    public static final int DEFAULT_RMI_SERVER_PORT = 44444;
    public static final int DEFAULT_RMI_REGISTRY_PORT = 1099;
    public static final int DEFAULT_HTTP_PORT = 8181;
    private static final String[] FALLBACK_REPOS = new String[]{"http://repo.fusesource.com/nexus/content/groups/public/", "http://repo.fusesource.com/nexus/content/groups/ea/", "http://repo.fusesource.com/nexus/content/repositories/snapshots/"};

    private ContainerProviderUtils() {
    }

    public static String buildInstallAndStartScript(CreateRemoteContainerOptions options) throws MalformedURLException, URISyntaxException {
        byte[] byArray;
        CreateContainerMetadata metadata;
        StringBuilder sb = new StringBuilder();
        sb.append("#!/bin/bash").append("\n");
        sb.append(RUN_FUNCTION).append("\n");
        sb.append(DOWNLOAD_FUNCTION).append("\n");
        sb.append(MAVEN_DOWNLOAD_FUNCTION).append("\n");
        sb.append(UPDATE_PKGS).append("\n");
        sb.append(INSTALL_CURL).append("\n");
        sb.append(INSTALL_UNZIP).append("\n");
        sb.append(INSTALL_JDK).append("\n");
        sb.append(VALIDATE_REQUIREMENTS).append("\n");
        sb.append(EXIT_IF_NOT_EXISTS).append("\n");
        sb.append(COPY_NODE_METADATA).append("\n");
        sb.append(KARAF_CHECK).append("\n");
        sb.append(REPLACE_IN_FILE).append("\n");
        sb.append(CONFIGURE_HOSTNAMES).append("\n");
        sb.append(FIND_FREE_PORT).append("\n");
        sb.append(WAIT_FOR_PORT).append("\n");
        sb.append("run mkdir -p ").append(options.getPath()).append("\n");
        sb.append("run cd ").append(options.getPath()).append("\n");
        sb.append("run mkdir -p ").append(options.getName()).append("\n");
        sb.append("run cd ").append(options.getName()).append("\n");
        if (options.isAdminAccess()) {
            sb.append("update_pkgs").append("\n");
            sb.append("install_openjdk").append("\n");
            sb.append("install_curl").append("\n");
            sb.append("install_unzip").append("\n");
        }
        sb.append("validate_requirements").append("\n");
        ContainerProviderUtils.extractZipIntoDirectory(sb, options.getProxyUri(), "org.fusesource.fabric", "fuse-fabric", FabricConstants.FABRIC_VERSION);
        sb.append("run cd `").append(FIRST_FABRIC_DIRECTORY).append("`\n");
        ArrayList<String> lines = new ArrayList<String>();
        String globalResolver = options.getResolver() != null ? options.getResolver() : "localhostname";
        lines.add("global.resolver=" + globalResolver);
        ContainerProviderUtils.appendFile(sb, "etc/system.properties", lines);
        ContainerProviderUtils.replaceLineInFile(sb, "etc/system.properties", "karaf.name=root", "karaf.name=" + options.getName());
        sb.append("SSH_PORT=").append("`find_free_port ").append(Ports.mapPortToRange(8101, options.getMinimumPort(), options.getMaximumPort())).append(" ").append(options.getMaximumPort()).append("`\n");
        sb.append("RMI_REGISTRY_PORT=").append("`find_free_port ").append(Ports.mapPortToRange(1099, options.getMinimumPort(), options.getMaximumPort())).append(" ").append(options.getMaximumPort()).append("`\n");
        sb.append("RMI_SERVER_PORT=").append("`find_free_port ").append(Ports.mapPortToRange(44444, options.getMinimumPort(), options.getMaximumPort())).append(" ").append(options.getMaximumPort()).append("`\n");
        sb.append("HTTP_PORT=").append("`find_free_port ").append(Ports.mapPortToRange(8181, options.getMinimumPort(), options.getMaximumPort())).append(" ").append(options.getMaximumPort()).append("`\n");
        ContainerProviderUtils.replaceLineInFile(sb, "etc/org.apache.karaf.shell.cfg", "sshPort=8101", "sshPort=$SSH_PORT");
        ContainerProviderUtils.replaceLineInFile(sb, "etc/org.apache.karaf.management.cfg", "rmiRegistryPort = 1099", "rmiRegistryPort=$RMI_REGISTRY_PORT");
        ContainerProviderUtils.replaceLineInFile(sb, "etc/org.apache.karaf.management.cfg", "rmiServerPort = 44444", "rmiServerPort=$RMI_SERVER_PORT");
        ContainerProviderUtils.replaceLineInFile(sb, "etc/org.ops4j.pax.web.cfg", String.valueOf(8181), "$HTTP_PORT");
        ContainerProviderUtils.replaceLineInFile(sb, "etc/jetty.xml", String.valueOf(8181), "$HTTP_PORT");
        ContainerProviderUtils.appendFile(sb, "etc/system.properties", Arrays.asList("minimum.port=" + options.getMinimumPort()));
        ContainerProviderUtils.appendFile(sb, "etc/system.properties", Arrays.asList("maximum.port=" + options.getMaximumPort()));
        ContainerProviderUtils.appendFile(sb, "etc/system.properties", Arrays.asList("\n"));
        for (Map.Entry<String, Properties> entry : options.getSystemProperties().entrySet()) {
            Properties sysprops = entry.getValue();
            for (Map.Entry<Object, Object> syspropEntry : sysprops.entrySet()) {
                Object type = syspropEntry.getKey();
                Object value = syspropEntry.getValue();
                ContainerProviderUtils.appendFile(sb, "etc/system.properties", Arrays.asList(type + "=" + value));
            }
        }
        if (options.getPreferredAddress() != null) {
            ContainerProviderUtils.appendFile(sb, "etc/system.properties", Arrays.asList("preferred.network.address=" + options.getPreferredAddress()));
        }
        if (options.isEnsembleServer()) {
            ContainerProviderUtils.appendFile(sb, "etc/system.properties", Arrays.asList("zookeeper.password = " + options.getZookeeperPassword()));
            ContainerProviderUtils.appendFile(sb, "etc/system.properties", Arrays.asList("ensemble.auto.start=true"));
            ContainerProviderUtils.appendFile(sb, "etc/system.properties", Arrays.asList("agent.auto.start=true"));
            ContainerProviderUtils.appendFile(sb, "etc/system.properties", Arrays.asList("profiles.auto.import.path=${karaf.home}/fabric/import/"));
            if (options.getCreateEnsembleOptions() != null && options.getCreateEnsembleOptions().getUsers() != null) {
                for (Map.Entry<String, Object> entry : options.getCreateEnsembleOptions().getUsers().entrySet()) {
                    ContainerProviderUtils.appendFile(sb, "etc/users.properties", Arrays.asList(entry.getKey() + "=" + (String)entry.getValue()));
                }
            }
        } else if (options.getZookeeperUrl() != null) {
            ContainerProviderUtils.appendFile(sb, "etc/system.properties", Arrays.asList("zookeeper.url = " + options.getZookeeperUrl()));
            ContainerProviderUtils.appendFile(sb, "etc/system.properties", Arrays.asList("zookeeper.password = " + options.getZookeeperPassword()));
            ContainerProviderUtils.appendFile(sb, "etc/system.properties", Arrays.asList("agent.auto.start=true"));
            ContainerProviderUtils.appendToLineInFile(sb, "etc/org.apache.karaf.features.cfg", "featuresBoot=", "fabric-agent,");
        }
        if (options.getProxyUri() != null) {
            ContainerProviderUtils.appendToLineInFile(sb, "etc/org.ops4j.pax.url.mvn.cfg", "repositories=", options.getProxyUri().toString() + ",");
        }
        if (options.isEnsembleServer() && (metadata = options.getMetadataMap().get(options.getName())) != null && (byArray = ObjectUtils.toBytes(metadata)) != null && byArray.length > 0) {
            sb.append("copy_node_metadata ").append(options.getName()).append(" ").append(new String(Base64Encoder.encode(byArray))).append("\n");
        }
        if (options instanceof CreateJCloudsContainerOptions) {
            sb.append("configure_hostnames").append(" ").append(((CreateJCloudsContainerOptions)options).getProviderName()).append("\n");
        }
        if (options.getJvmOpts() != null && !options.getJvmOpts().contains("-XX:+UnlockDiagnosticVMOptions -XX:+UnsyncloadClass")) {
            options.setJvmOpts(options.getJvmOpts() + " -XX:+UnlockDiagnosticVMOptions -XX:+UnsyncloadClass");
        }
        if (options.getJvmOpts() != null && !options.getJvmOpts().isEmpty()) {
            sb.append("export JAVA_OPTS=\"" + options.getJvmOpts()).append("\"\n");
        }
        sb.append("nohup bin/start &").append("\n");
        sb.append("karaf_check `pwd`").append("\n");
        sb.append("wait_for_port $SSH_PORT").append("\n");
        sb.append("wait_for_port $RMI_REGISTRY_PORT").append("\n");
        return sb.toString();
    }

    public static String buildStartScript(CreateRemoteContainerOptions options) throws MalformedURLException {
        StringBuilder sb = new StringBuilder();
        sb.append("#!/bin/bash").append("\n");
        sb.append(RUN_FUNCTION).append("\n");
        sb.append(KARAF_CHECK).append("\n");
        sb.append(CONFIGURE_HOSTNAMES).append("\n");
        sb.append("run cd ").append(options.getPath()).append("\n");
        sb.append("run cd ").append(options.getName()).append("\n");
        sb.append("run cd `").append(FIRST_FABRIC_DIRECTORY).append("`\n");
        if (options instanceof CreateJCloudsContainerOptions) {
            sb.append("configure_hostnames").append(" ").append(((CreateJCloudsContainerOptions)options).getProviderName()).append("\n");
        }
        if (options.getJvmOpts() != null && !options.getJvmOpts().contains("-XX:+UnlockDiagnosticVMOptions -XX:+UnsyncloadClass")) {
            options.setJvmOpts(options.getJvmOpts() + " -XX:+UnlockDiagnosticVMOptions -XX:+UnsyncloadClass");
        }
        if (options.getJvmOpts() != null && !options.getJvmOpts().isEmpty()) {
            sb.append("export JAVA_OPTS=\"" + options.getJvmOpts()).append("\"\n");
        }
        sb.append("nohup bin/start &").append("\n");
        sb.append("karaf_check `pwd`").append("\n");
        return sb.toString();
    }

    public static String buildStopScript(CreateRemoteContainerOptions options) throws MalformedURLException {
        StringBuilder sb = new StringBuilder();
        sb.append("#!/bin/bash").append("\n");
        sb.append(RUN_FUNCTION).append("\n");
        sb.append(KARAF_KILL).append("\n");
        sb.append("run cd ").append(options.getPath()).append("\n");
        sb.append("run cd ").append(options.getName()).append("\n");
        sb.append("run cd `").append(FIRST_FABRIC_DIRECTORY).append("`\n");
        sb.append("karaf_kill `pwd`").append("\n");
        return sb.toString();
    }

    public static String buildUninstallScript(CreateRemoteContainerOptions options) throws MalformedURLException {
        StringBuilder sb = new StringBuilder();
        sb.append(RUN_FUNCTION).append("\n");
        sb.append(KARAF_KILL).append("\n");
        sb.append("run cd ").append(options.getPath()).append("\n");
        sb.append("run cd ").append(options.getName()).append("\n");
        sb.append("run cd `").append(FIRST_FABRIC_DIRECTORY).append("`\n");
        sb.append("karaf_kill `pwd`").append("\n");
        sb.append("run cd  ../..").append("\n");
        sb.append("run rm -rf ").append(options.getName()).append("\n");
        return sb.toString();
    }

    private static void replaceLineInFile(StringBuilder sb, String path, String pattern, String line) {
        sb.append("replace_in_file ").append("\"").append(pattern).append("\" ").append("\"").append(line).append("\" ").append(path).append("\n");
    }

    private static void appendToLineInFile(StringBuilder sb, String path, String pattern, String line) {
        sb.append(String.format(LINE_APPEND, pattern.replaceAll("/", "\\\\/"), line.replaceAll("/", "\\\\/"), path, path + ".tmp")).append("\n");
        sb.append("mv " + path + ".tmp " + path).append("\n");
    }

    private static void appendFile(StringBuilder sb, String path, Iterable<String> lines) {
        String marker = "END_OF_FILE";
        sb.append("cat >> ").append(path).append(" <<'").append("END_OF_FILE").append("'\n");
        for (String line : lines) {
            sb.append(line).append("\n");
        }
        sb.append("END_OF_FILE").append("\n");
    }

    private static void extractZipIntoDirectory(StringBuilder sb, URI proxy, String groupId, String artifactId, String version) throws URISyntaxException {
        String file = artifactId + "-" + version + ".zip";
        if (proxy != null) {
            String baseProxyURL = !proxy.toString().endsWith("/") ? proxy.toString() + "/" : proxy.toString();
            sb.append("maven_download ").append(baseProxyURL).append(" ").append(groupId).append(" ").append(artifactId).append(" ").append(version).append(" ").append("zip").append("\n");
        }
        for (String fallbackRepo : FALLBACK_REPOS) {
            sb.append("if [ ! -f " + file + " ] ; then ").append("maven_download ").append(fallbackRepo).append(" ").append(groupId).append(" ").append(artifactId).append(" ").append(version).append(" ").append("zip").append(" ; fi \n");
        }
        sb.append("exit_if_not_exists ").append(file).append("\n");
        sb.append("run unzip ").append(file).append("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadFunction(String function) {
        InputStream is = ContainerProviderUtils.class.getResourceAsStream(function);
        InputStreamReader reader = null;
        BufferedReader bufferedReader = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            reader = new InputStreamReader(is, "UTF-8");
            bufferedReader = new BufferedReader(reader);
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        catch (Throwable e) {
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Throwable e) {}
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Throwable e) {}
            try {
                is.close();
            }
            catch (Throwable e) {}
        }
        return sb.toString();
    }

    public static String parseScriptFailure(String output) {
        String error = "";
        if (output != null) {
            String[] lines;
            for (String line : lines = output.split("\n")) {
                if (!line.contains(FAILURE_PREFIX)) continue;
                try {
                    error = line.substring(line.lastIndexOf(FAILURE_PREFIX) + FAILURE_PREFIX.length());
                }
                catch (Throwable t) {
                    error = "Unknown error";
                }
                return error;
            }
        }
        return error;
    }

    public static String parseResolverOverride(String output) {
        String resolver = null;
        if (output != null) {
            String[] lines;
            for (String line : lines = output.split("\n")) {
                if (!line.contains(RESOLVER_OVERRIDE)) continue;
                try {
                    resolver = line.substring(line.lastIndexOf(RESOLVER_OVERRIDE) + RESOLVER_OVERRIDE.length());
                    return resolver.trim();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        return resolver;
    }
}

