/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.maven.impl;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import org.apache.zookeeper.CreateMode;
import org.fusesource.fabric.maven.impl.MavenDownloadProxyServlet;
import org.fusesource.fabric.maven.impl.MavenUploadProxyServlet;
import org.fusesource.fabric.maven.impl.SecureHttpContext;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.linkedin.zookeeper.client.LifecycleListener;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenProxyRegistrationHandler
implements LifecycleListener,
ConfigurationListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenProxyRegistrationHandler.class);
    private String port;
    private final Map<String, Set<String>> registeredProxies = new HashMap<String, Set<String>>();
    private IZKClient zookeeper = null;
    private boolean connected = false;
    private String name = System.getProperty("karaf.name");
    private String realm;
    private String role;
    private HttpService httpService;
    private MavenDownloadProxyServlet mavenDownloadProxyServlet;
    private MavenUploadProxyServlet mavenUploadProxyServlet;
    private ConfigurationAdmin configurationAdmin;

    public MavenProxyRegistrationHandler() {
        this.registeredProxies.put("download", new HashSet());
        this.registeredProxies.put("upload", new HashSet());
    }

    public void init() {
    }

    public void destroy() {
        this.unregister("download");
        this.unregister("upload");
        try {
            if (this.httpService != null) {
                this.httpService.unregister("/maven/download");
                this.httpService.unregister("/maven/upload");
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Http service returned error on servlet unregister. Possibly the service has already been stopped");
        }
    }

    public void bindHttpService(HttpService httpService) {
        this.httpService = httpService;
        this.port = this.getPortFromConfig();
        if (httpService != null && this.mavenDownloadProxyServlet != null && this.mavenUploadProxyServlet != null) {
            try {
                HttpContext base = httpService.createDefaultHttpContext();
                SecureHttpContext secure = new SecureHttpContext(base, this.realm, this.role);
                httpService.registerServlet("/maven/download", (Servlet)this.mavenDownloadProxyServlet, null, base);
                httpService.registerServlet("/maven/upload", (Servlet)this.mavenUploadProxyServlet, null, (HttpContext)secure);
            }
            catch (Throwable t) {
                LOGGER.warn("Failed to register fabric maven proxy servlets, due to:" + t.getMessage());
            }
            this.register("download");
            this.register("upload");
        }
    }

    public void unbindHttpService(HttpService httpService) {
        this.unregister("download");
        this.unregister("upload");
        this.httpService = null;
    }

    public void bindZooKeeper(IZKClient zookeeper) {
        this.zookeeper = zookeeper;
        if (zookeeper != null) {
            zookeeper.registerListener(this);
        }
    }

    public void unbindZooKeeper(IZKClient zookeeper) {
        if (zookeeper != null) {
            zookeeper.removeListener(this);
        }
        this.connected = false;
        this.zookeeper = null;
    }

    public void onConnected() {
        this.connected = true;
        this.register("download");
        this.register("upload");
    }

    public void onDisconnected() {
        this.connected = false;
    }

    public void register(String type) {
        this.unregister(type);
        try {
            if (this.connected && this.httpService != null) {
                String mavenProxyUrl = "http://${zk:" + this.name + "/ip}:" + this.getPortSafe() + "/maven/" + type + "/";
                String parentPath = ZkPath.MAVEN_PROXY.getPath(type);
                String path = parentPath + "/p_";
                if (this.zookeeper.exists(parentPath) == null) {
                    this.zookeeper.createWithParents(parentPath, CreateMode.PERSISTENT);
                }
                if (this.zookeeper.exists(path) == null) {
                    this.registeredProxies.get(type).add(this.zookeeper.create(path, mavenProxyUrl, CreateMode.EPHEMERAL_SEQUENTIAL));
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to register maven proxy.");
        }
    }

    public void unregister(String type) {
        Set<String> proxyNodes = this.registeredProxies.get(type);
        if (proxyNodes != null) {
            try {
                if (this.connected) {
                    for (String entry : this.registeredProxies.get(type)) {
                        if (this.zookeeper.exists(entry) == null) continue;
                        this.zookeeper.deleteWithChildren(entry);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to remove maven proxy from registry.");
            }
            this.registeredProxies.get(type).clear();
        }
    }

    public void configurationEvent(ConfigurationEvent event) {
        if (event.getPid().equals("org.ops4j.pax.web") && event.getType() == 1) {
            this.port = this.getPortFromConfig();
            this.register("download");
            this.register("upload");
        }
    }

    public String getPortFromConfig() {
        String port = "8181";
        try {
            Configuration configuration;
            Dictionary properties;
            Configuration[] configurations = this.configurationAdmin.listConfigurations("(service.pid=org.ops4j.pax.web)");
            if (configurations != null && configurations.length > 0 && (properties = (configuration = configurations[0]).getProperties()) != null && properties.get("org.osgi.service.http.port") != null) {
                port = String.valueOf(properties.get("org.osgi.service.http.port"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return port;
    }

    private int getPortSafe() {
        int port = 8181;
        try {
            port = Integer.parseInt(this.getPort());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return port;
    }

    public String getPort() {
        return this.port;
    }

    public MavenDownloadProxyServlet getMavenDownloadProxyServlet() {
        return this.mavenDownloadProxyServlet;
    }

    public void setMavenDownloadProxyServlet(MavenDownloadProxyServlet mavenDownloadProxyServlet) {
        this.mavenDownloadProxyServlet = mavenDownloadProxyServlet;
    }

    public MavenUploadProxyServlet getMavenUploadProxyServlet() {
        return this.mavenUploadProxyServlet;
    }

    public void setMavenUploadProxyServlet(MavenUploadProxyServlet mavenUploadProxyServlet) {
        this.mavenUploadProxyServlet = mavenUploadProxyServlet;
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }
}

