/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.utils.shell;

import java.io.IOException;
import java.security.AccessController;
import java.util.Set;
import javax.security.auth.Subject;
import jline.Terminal;
import jline.console.ConsoleReader;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;

public class ShellUtils {
    private static final String FABRIC_USER = "FABRIC_USER";
    private static final String FABRIC_USER_PASSWORD = "FABRIC_USER_PASSWORD";
    private static final String FABRIC_ZOOKEEPER_PASSWORD = "FABRIC_ZOOKEEPER_PASSWORD";

    private ShellUtils() {
    }

    public static void storeFabricCredentials(CommandSession session, String username, String password) {
        session.put(FABRIC_USER, username);
        session.put(FABRIC_USER_PASSWORD, password);
    }

    public static void storeZookeeperPassword(CommandSession session, String zookeeperPassword) {
        session.put(FABRIC_ZOOKEEPER_PASSWORD, zookeeperPassword);
    }

    public static String retrieveFabricUser(CommandSession session) {
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject != null && subject.getPrivateCredentials(String.class) != null && !subject.getPrivateCredentials(String.class).isEmpty() && subject.getPrincipals(UserPrincipal.class) != null && !subject.getPrincipals(UserPrincipal.class).isEmpty()) {
            Set<UserPrincipal> userPrincipals = subject.getPrincipals(UserPrincipal.class);
            UserPrincipal userPrincipal = userPrincipals.iterator().next();
            return userPrincipal.getName();
        }
        if (session != null && session.get(FABRIC_USER) != null) {
            return (String)session.get(FABRIC_USER);
        }
        return null;
    }

    public static String retrieveFabricUserPassword(CommandSession session) {
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject != null && subject.getPrivateCredentials(String.class) != null && !subject.getPrivateCredentials(String.class).isEmpty() && subject.getPrincipals(UserPrincipal.class) != null && !subject.getPrincipals(UserPrincipal.class).isEmpty()) {
            return subject.getPrivateCredentials(String.class).iterator().next();
        }
        if (session != null && session.get(FABRIC_USER_PASSWORD) != null) {
            return (String)session.get(FABRIC_USER_PASSWORD);
        }
        return null;
    }

    public static String retrieveFabricZookeeperPassword(CommandSession session) {
        if (session != null && session.get(FABRIC_USER_PASSWORD) != null) {
            return (String)session.get(FABRIC_USER_PASSWORD);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readLine(CommandSession session, String msg, boolean hidden) throws IOException {
        Object obj = session.get(".jline.reader");
        if (obj instanceof ConsoleReader) {
            ConsoleReader reader = (ConsoleReader)obj;
            try {
                reader.setHistoryEnabled(false);
                if (hidden) {
                    String string = reader.readLine(msg, Character.valueOf('\u0000'));
                    return string;
                }
                String string = reader.readLine(msg);
                return string;
            }
            finally {
                reader.setHistoryEnabled(true);
            }
        }
        return null;
    }

    public static int getTermWidth(CommandSession session) {
        Terminal term = (Terminal)session.get(".jline.terminal");
        return term != null ? term.getWidth() : 80;
    }
}

