/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.internal;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.zookeeper.Watcher;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.fabric.zookeeper.internal.AbstractZKClient;
import org.linkedin.util.clock.Timespan;
import org.linkedin.zookeeper.client.LifecycleListener;
import org.linkedin.zookeeper.client.ZooKeeperFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiZkClient
extends AbstractZKClient
implements ManagedService {
    public static final String PID = "org.fusesource.fabric.zookeeper";
    private static final Logger LOG = LoggerFactory.getLogger((String)OsgiZkClient.class.getName());
    private ConfigurationAdmin configurationAdmin;
    private BundleContext bundleContext;
    private ServiceRegistration managedServiceRegistration;
    private ServiceRegistration zkClientRegistration;

    public OsgiZkClient() {
        super(null);
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    protected void doStart() throws InvalidSyntaxException, ConfigurationException {
        this.bundleContext.addServiceListener(new ServiceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serviceChanged(ServiceEvent event) {
                if (OsgiZkClient.this.isConnected() && event.getType() == 1) {
                    LifecycleListener listener = (LifecycleListener)OsgiZkClient.this.bundleContext.getService(event.getServiceReference());
                    try {
                        listener.onConnected();
                    }
                    catch (Throwable e) {
                        LOG.warn("Exception while executing listener (ignored)", e);
                    }
                    finally {
                        OsgiZkClient.this.bundleContext.ungetService(event.getServiceReference());
                    }
                }
            }
        }, "(objectClass=" + LifecycleListener.class.getName() + ")");
        Hashtable<String, String> ht = new Hashtable<String, String>();
        this.zkClientRegistration = this.bundleContext.registerService(new String[]{IZKClient.class.getName(), org.linkedin.zookeeper.client.IZKClient.class.getName()}, (Object)this, ht);
        ht = new Hashtable();
        ht.put("service.pid", PID);
        this.managedServiceRegistration = this.bundleContext.registerService(ManagedService.class.getName(), (Object)this, ht);
        this.updated(this.getDefaultProperties());
    }

    private Dictionary getDefaultProperties() {
        try {
            Configuration c = this.configurationAdmin != null ? this.configurationAdmin.getConfiguration(PID, null) : null;
            return c != null ? c.getProperties() : null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public void close() {
        ServiceRegistration srMs = this.managedServiceRegistration;
        ServiceRegistration srZk = this.zkClientRegistration;
        this.managedServiceRegistration = null;
        this.zkClientRegistration = null;
        if (srMs != null) {
            srMs.unregister();
        }
        if (srZk != null) {
            srZk.unregister();
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(Dictionary properties) throws ConfigurationException {
        Object object = this._lock;
        synchronized (object) {
            String url = System.getProperty("zookeeper.url");
            String password = System.getProperty("zookeeper.password");
            HashMap<String, String> acls = new HashMap<String, String>();
            if (properties != null) {
                if (properties.get("zookeeper.url") != null) {
                    url = (String)properties.get("zookeeper.url");
                }
                if (properties.get("zookeeper.timeout") != null) {
                    this.sessionTimeout = Timespan.parse((String)((String)properties.get("zookeeper.timeout")));
                }
                if (properties.get("zookeeper.password") != null) {
                    password = (String)properties.get("zookeeper.password");
                }
                Enumeration e = properties.keys();
                while (e.hasMoreElements()) {
                    String key = e.nextElement().toString();
                    if (!key.startsWith("acls.")) continue;
                    String val = properties.get(key).toString();
                    acls.put(key.substring("acls.".length()), val);
                }
            }
            if (!acls.containsKey("/")) {
                acls.put("/", "world:anyone:acdrw");
                acls.put("/fabric", "auth::acdrw,world:anyone:");
            }
            this.setACLs(acls);
            this.setPassword(password);
            if (this._factory == null && url == null || this._factory != null && url != null && this.getConnectString().equals(url)) {
                return;
            }
            if (this.isConfigured()) {
                this.changeState(url != null ? AbstractZKClient.State.RECONNECTING : AbstractZKClient.State.NONE);
                try {
                    this._zk.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                this._zk = null;
                this._factory = null;
            }
            if (url != null) {
                this._factory = new ZooKeeperFactory(url, this.sessionTimeout, (Watcher)this);
                this.tryConnect();
            }
            if (this.zkClientRegistration != null) {
                this.zkClientRegistration.setProperties(properties);
            }
        }
    }

    @Override
    protected Map<Object, Boolean> callListeners(Map<Object, Boolean> history, Boolean connectedEvent) {
        Map<Object, Boolean> newHistory;
        block8: {
            newHistory = super.callListeners(history, connectedEvent);
            try {
                ServiceReference[] references = this.bundleContext.getServiceReferences(LifecycleListener.class.getName(), null);
                if (references == null) break block8;
                for (ServiceReference reference : references) {
                    LifecycleListener listener = (LifecycleListener)this.bundleContext.getService(reference);
                    Boolean previousEvent = history.get(reference);
                    if (previousEvent == null || previousEvent != connectedEvent) {
                        try {
                            if (connectedEvent.booleanValue()) {
                                listener.onConnected();
                            } else {
                                listener.onDisconnected();
                            }
                        }
                        catch (Throwable e) {
                            LOG.warn("Exception while executing listener (ignored)", e);
                        }
                    }
                    newHistory.put(reference, connectedEvent);
                    this.bundleContext.ungetService(reference);
                }
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalStateException(e);
            }
        }
        return newHistory;
    }
}

