/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.spring;

import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.Watcher;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.fabric.zookeeper.internal.ZKClient;
import org.linkedin.util.clock.Timespan;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;

public class ZKClientFactoryBean
implements FactoryBean<IZKClient>,
DisposableBean {
    private static final transient Log LOG = LogFactory.getLog(ZKClientFactoryBean.class);
    private String connectString = "localhost:2181";
    private String password;
    private String timeoutText = "30s";
    private Watcher watcher;
    private Timespan timeout;
    protected ZKClient zkClient;
    private Timespan connectTimeout = Timespan.parse((String)"10s");

    public String getConnectString() {
        return this.connectString;
    }

    public void setConnectString(String connectString) {
        this.connectString = connectString;
    }

    public Timespan getTimeout() {
        if (this.timeout == null) {
            this.timeout = Timespan.parse((String)this.timeoutText);
        }
        return this.timeout;
    }

    public void setTimeout(Timespan timeout) {
        this.timeout = timeout;
    }

    public String getTimeoutText() {
        return this.timeoutText;
    }

    public void setTimeoutText(String timeoutText) {
        this.timeoutText = timeoutText;
    }

    public Watcher getWatcher() {
        return this.watcher;
    }

    public void setWatcher(Watcher watcher) {
        this.watcher = watcher;
    }

    public Timespan getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Timespan connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public IZKClient getObject() throws Exception {
        LOG.debug((Object)("Connecting to ZooKeeper on " + this.connectString));
        this.zkClient = new ZKClient(this.connectString, this.getTimeout(), this.watcher);
        this.zkClient.setPassword(this.password);
        this.zkClient.start();
        try {
            this.zkClient.waitForConnected(this.connectTimeout);
        }
        catch (TimeoutException e) {
            throw new Exception("Failed to connect to ZooKeeper on " + this.connectString, e);
        }
        return this.zkClient;
    }

    public Class<?> getObjectType() {
        return IZKClient.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        if (this.zkClient != null) {
            this.zkClient.close();
            this.zkClient = null;
        }
    }
}

