/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.utils;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.fusesource.fabric.zookeeper.utils.InterpolationHelper;
import org.linkedin.zookeeper.client.ZKData;

public final class ZooKeeperUtils {
    private ZooKeeperUtils() {
    }

    public static void copy(IZKClient source, IZKClient dest, String path) throws InterruptedException, KeeperException {
        for (String child : source.getChildren(path)) {
            child = path + "/" + child;
            if (dest.exists(child) != null) continue;
            byte[] data = source.getData(child);
            ZooKeeperUtils.set(dest, child, data);
            ZooKeeperUtils.copy(source, dest, child);
        }
    }

    public static void copy(IZKClient zk, String from, String to) throws InterruptedException, KeeperException {
        for (String child : zk.getChildren(from)) {
            String fromChild = from + "/" + child;
            String toChild = to + "/" + child;
            if (zk.exists(toChild) != null) continue;
            byte[] data = zk.getData(fromChild);
            ZooKeeperUtils.set(zk, toChild, data);
            ZooKeeperUtils.copy(zk, fromChild, toChild);
        }
    }

    public static void add(IZKClient zooKeeper, String path, String value) throws InterruptedException, KeeperException {
        if (zooKeeper.exists(path) == null) {
            zooKeeper.createOrSetWithParents(path, value, CreateMode.PERSISTENT);
        } else {
            String data = zooKeeper.getStringData(path);
            if (data == null) {
                data = "";
            }
            if (data.length() > 0) {
                data = data + " ";
            }
            data = data + value;
            zooKeeper.setData(path, data);
        }
    }

    public static void remove(IZKClient zooKeeper, String path, String value) throws InterruptedException, KeeperException {
        if (zooKeeper.exists(path) != null) {
            AbstractList parts = new LinkedList();
            String data = zooKeeper.getStringData(path);
            if (data != null) {
                parts = new ArrayList<String>(Arrays.asList(data.split(" ")));
            }
            boolean changed2 = false;
            StringBuilder sb = new StringBuilder();
            Iterator it = parts.iterator();
            while (it.hasNext()) {
                String v = (String)it.next();
                if (!v.matches(value)) continue;
                it.remove();
                changed2 = true;
            }
            if (changed2) {
                sb.delete(0, sb.length());
                for (String part : parts) {
                    if (data.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(part);
                }
                zooKeeper.setData(path, sb.toString());
            }
        }
    }

    public static String get(IZKClient zooKeeper, String path) throws InterruptedException, KeeperException {
        return zooKeeper.getStringData(path);
    }

    public static void set(IZKClient zooKeeper, String path, String value) throws InterruptedException, KeeperException {
        zooKeeper.createOrSetWithParents(path, value, CreateMode.PERSISTENT);
    }

    public static void set(IZKClient zooKeeper, String path, byte[] value) throws InterruptedException, KeeperException {
        if (zooKeeper.exists(path) != null) {
            zooKeeper.setByteData(path, value);
        }
        try {
            zooKeeper.createWithParents(path, value, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException e) {
            zooKeeper.setByteData(path, value);
        }
    }

    public static void create(IZKClient zooKeeper, String path) throws InterruptedException, KeeperException {
        zooKeeper.createWithParents(path, CreateMode.PERSISTENT);
    }

    public static void createDefault(IZKClient zooKeeper, String path, String value) throws InterruptedException, KeeperException {
        if (zooKeeper.exists(path) == null) {
            zooKeeper.createWithParents(path, value, CreateMode.PERSISTENT);
        }
    }

    public static void deleteSafe(IZKClient zooKeeper, String path) throws InterruptedException, KeeperException {
        if (ZooKeeperUtils.exists(zooKeeper, path) != null) {
            zooKeeper.deleteWithChildren(path);
        }
    }

    public static Stat exists(IZKClient zooKeeper, String path) throws InterruptedException, KeeperException {
        return zooKeeper.exists(path);
    }

    public static Properties getProperties(IZKClient zooKeeper, String path, Watcher watcher) throws InterruptedException, KeeperException {
        ZKData zkData = zooKeeper.getZKStringData(path, watcher);
        String value = (String)zkData.getData();
        Properties properties = new Properties();
        if (value != null) {
            try {
                properties.load(new StringReader(value));
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        return properties;
    }

    public static Properties getProperties(IZKClient zooKeeper, String path) throws InterruptedException, KeeperException {
        ZKData zkData = zooKeeper.getZKStringData(path);
        String value = (String)zkData.getData();
        Properties properties = new Properties();
        if (value != null) {
            try {
                properties.load(new StringReader(value));
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        return properties;
    }

    public static void setProperties(IZKClient zooKeeper, String path, Properties properties) throws InterruptedException, KeeperException {
        StringWriter writer = new StringWriter();
        try {
            properties.store(writer, null);
            zooKeeper.setData(path, writer.toString());
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public static String getSubstitutedPath(IZKClient zooKeeper, String path) throws InterruptedException, KeeperException, IOException, URISyntaxException {
        byte[] data;
        String normaledPath;
        String string = normaledPath = path != null && path.contains("#") ? path.substring(0, path.lastIndexOf(35)) : path;
        if (normaledPath != null && zooKeeper.exists(normaledPath) != null && (data = ZkPath.loadURL(zooKeeper, path)) != null && data.length > 0) {
            String str = new String(ZkPath.loadURL(zooKeeper, path), "UTF-8");
            return ZooKeeperUtils.getSubstitutedData(zooKeeper, str);
        }
        return null;
    }

    public static String getSubstitutedData(final IZKClient zooKeeper, String data) throws URISyntaxException {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("data", data);
        InterpolationHelper.performSubstitution(props, new InterpolationHelper.SubstitutionCallback(){

            @Override
            public String getValue(String key) {
                if (key.startsWith("zk:")) {
                    try {
                        return new String(ZkPath.loadURL(zooKeeper, key), "UTF-8");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
        return (String)props.get("data");
    }

    public static String generatePassword() {
        StringBuilder password = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            long l = Math.round(Math.floor(Math.random() * 62.0));
            if (l < 10L) {
                password.append((char)(48L + l));
                continue;
            }
            if (l < 36L) {
                password.append((char)(65L + l - 10L));
                continue;
            }
            password.append((char)(97L + l - 36L));
        }
        return password.toString();
    }
}

