/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.fusesource.fabric.utils.Closeables;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.fabric.zookeeper.utils.RegexSupport;
import org.fusesource.fabric.zookeeper.utils.ZookeeperCommandBuilder;

public class ZookeeperImportUtils {
    private ZookeeperImportUtils() {
    }

    public static void importFromFileSystem(IZKClient zooKeeper, String source, String target, String[] includeRegex, String[] excludeRegex, boolean delete, boolean dryRun, boolean verbose) throws Exception {
        TreeMap<String, String> settings = new TreeMap<String, String>();
        File s = new File(source);
        ZookeeperImportUtils.getCandidates(zooKeeper, s, s, settings, target);
        List<Pattern> include = RegexSupport.getPatterns(includeRegex);
        List<Pattern> exclude = RegexSupport.getPatterns(excludeRegex);
        if (!target.endsWith("/")) {
            target = target + "/";
        }
        if (!target.startsWith("/")) {
            target = "/" + target;
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (Map.Entry entry : settings.entrySet()) {
            String key = (String)entry.getKey();
            String data = (String)entry.getValue();
            key = target + key;
            paths.add(key);
            if (!RegexSupport.matches(include, key, true) || RegexSupport.matches(exclude, key, false)) continue;
            if (!dryRun) {
                if (data == null) continue;
                if (verbose) {
                    System.out.println("importing: " + key);
                }
                ZookeeperCommandBuilder.set(key, data).execute(zooKeeper);
                continue;
            }
            System.out.printf("Creating path \"%s\" with value \"%s\"\n", key, data);
        }
        if (delete) {
            ZookeeperImportUtils.deletePathsNotIn(zooKeeper, paths, target, dryRun);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importFromPropertiesFile(IZKClient zooKeeper, String source, String target, String[] includeRegex, String[] excludeRegex, boolean dryRun) throws Exception {
        List<Pattern> includes = RegexSupport.getPatterns(includeRegex);
        List<Pattern> excludes = RegexSupport.getPatterns(excludeRegex);
        InputStream in = null;
        try {
            new BufferedInputStream(new URL(source).openStream());
            Properties props = new Properties();
            props.load(in);
            Enumeration<?> names = props.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = props.getProperty(name);
                if (value != null && value.isEmpty()) {
                    value = null;
                }
                if (!name.startsWith("/")) {
                    name = "/" + name;
                }
                if (!RegexSupport.matches(includes, name = target + name, true) || RegexSupport.matches(excludes, name, false)) continue;
                if (!dryRun) {
                    ZookeeperCommandBuilder.set(name, value).execute(zooKeeper);
                    continue;
                }
                System.out.printf("Creating path \"%s\" with value \"%s\"\n", name, value);
            }
        }
        finally {
            Closeables.closeQuitely(in);
        }
    }

    private static void getCandidates(IZKClient zookeeper, File parent, File current, Map<String, String> settings, String target) throws Exception {
        List<Pattern> profile = RegexSupport.getPatterns(new String[]{"/fabric/configs/versions/[\\w\\.\\-]*/profiles/[\\w\\.\\-]*"});
        List<Pattern> containerProperties = RegexSupport.getPatterns(new String[]{"/fabric/configs/versions/[\\w\\.\\-]*/profiles/[\\w\\.\\-]*/org.fusesource.fabric.agent.properties"});
        List<Pattern> attributes = RegexSupport.getPatterns(new String[]{"/fabric/configs/versions/[\\w\\.\\-]*/profiles/[\\w\\.\\-]*/attributes.properties"});
        if (current.isDirectory()) {
            for (File child : current.listFiles()) {
                ZookeeperImportUtils.getCandidates(zookeeper, parent, child, settings, target);
            }
            String p = ZookeeperImportUtils.buildZKPath(parent, current).replaceFirst("/", "");
            if (!RegexSupport.matches(profile, "/" + p, false)) {
                settings.put(p, null);
            }
        } else {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(current));
            byte[] contents = new byte[in.available()];
            in.read(contents);
            in.close();
            String p = ZookeeperImportUtils.buildZKPath(parent, current).replaceFirst("/", "");
            if (p.endsWith(".cfg")) {
                p = p.substring(0, p.length() - ".cfg".length());
            }
            if (RegexSupport.matches(attributes, "/" + p, false)) {
                settings.put(p.substring(0, p.lastIndexOf(47)), new String(contents));
            } else if (RegexSupport.matches(containerProperties, "/" + p, false)) {
                String parents;
                settings.put(p, new String(contents).replaceAll("parents=[[\\w\\-\\.]*[ \\t]]*", ""));
                Properties props = new Properties();
                props.load(new StringReader(new String(contents)));
                if (settings.get(p.substring(0, p.lastIndexOf(47))) == null && (parents = (String)props.get("parents")) != null && !parents.isEmpty()) {
                    settings.put(p.substring(0, p.lastIndexOf(47)), "parents=" + parents);
                }
            } else if (!RegexSupport.matches(profile, "/" + p, false)) {
                settings.put(p, new String(contents));
            }
        }
    }

    private static String buildZKPath(File parent, File current) {
        String rc = "";
        if (current != null && !parent.equals(current)) {
            rc = ZookeeperImportUtils.buildZKPath(parent, current.getParentFile()) + "/" + current.getName();
        }
        return rc;
    }

    private static void deletePathsNotIn(IZKClient zookeeper, List<String> paths, String target, boolean dryRun) throws Exception {
        List<String> zkPaths = ZookeeperCommandBuilder.getChildren(target).execute(zookeeper);
        for (String path : zkPaths) {
            path = "/" + path;
            if (paths.contains(path)) continue;
            if (!dryRun) {
                ZookeeperCommandBuilder.delete(path).execute(zookeeper);
                continue;
            }
            System.out.printf("Deleting path %s and everything under it\n", path);
        }
    }
}

