/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.domain;

import com.google.common.base.Preconditions;

public class PlacementGroup
implements Comparable<PlacementGroup> {
    private final String region;
    private final String name;
    private final String strategy;
    private final State state;

    public PlacementGroup(String region, String name, String strategy, State state) {
        this.region = Preconditions.checkNotNull(region, "region");
        this.name = Preconditions.checkNotNull(name, "name");
        this.strategy = Preconditions.checkNotNull(strategy, "strategy");
        this.state = Preconditions.checkNotNull(state, "state");
    }

    @Override
    public int compareTo(PlacementGroup o) {
        return this.name.compareTo(o.name);
    }

    @Deprecated
    public String getRegion() {
        return this.region;
    }

    public String getName() {
        return this.name;
    }

    public String getStrategy() {
        return this.strategy;
    }

    public State getState() {
        return this.state;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.strategy == null ? 0 : this.strategy.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlacementGroup other = (PlacementGroup)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.region == null ? other.region != null : !this.region.equals(other.region)) {
            return false;
        }
        if (this.state == null ? other.state != null : !this.state.equals((Object)other.state)) {
            return false;
        }
        return !(this.strategy == null ? other.strategy != null : !this.strategy.equals(other.strategy));
    }

    public String toString() {
        return "[name=" + this.name + ", region=" + this.region + ", state=" + (Object)((Object)this.state) + ", strategy=" + this.strategy + "]";
    }

    public static enum State {
        PENDING,
        AVAILABLE,
        DELETING,
        DELETED,
        UNRECOGNIZED;


        public String value() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.value();
        }

        public static State fromValue(String state) {
            try {
                return State.valueOf(Preconditions.checkNotNull(state, "state").toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

