/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.aws.s3.binders.BindIterableAsPayloadToDeleteRequest;
import org.jclouds.aws.s3.binders.BindObjectMetadataToRequest;
import org.jclouds.aws.s3.binders.BindPartIdsAndETagsToRequest;
import org.jclouds.aws.s3.domain.DeleteResult;
import org.jclouds.aws.s3.functions.ETagFromHttpResponseViaRegex;
import org.jclouds.aws.s3.functions.ObjectMetadataKey;
import org.jclouds.aws.s3.functions.UploadIdFromHttpResponseViaRegex;
import org.jclouds.aws.s3.xml.DeleteResultHandler;
import org.jclouds.blobstore.attr.BlobScope;
import org.jclouds.blobstore.attr.BlobScopes;
import org.jclouds.http.functions.ParseETagHeader;
import org.jclouds.io.Payload;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.ParamValidators;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;
import org.jclouds.s3.Bucket;
import org.jclouds.s3.S3AsyncClient;
import org.jclouds.s3.binders.BindAsHostPrefixIfConfigured;
import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.s3.filters.RequestAuthorizeSignature;
import org.jclouds.s3.functions.AssignCorrectHostnameForBucket;
import org.jclouds.s3.options.PutObjectOptions;
import org.jclouds.s3.predicates.validators.BucketNameValidator;

@RequestFilters(value={RequestAuthorizeSignature.class})
@BlobScope(value=BlobScopes.CONTAINER)
public interface AWSS3AsyncClient
extends S3AsyncClient {
    @Named(value="s3:PutObject")
    @POST
    @QueryParams(keys={"uploads"})
    @Path(value="/{key}")
    @ResponseParser(value=UploadIdFromHttpResponseViaRegex.class)
    public ListenableFuture<String> initiateMultipartUpload(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") @ParamParser(value=ObjectMetadataKey.class) @BinderParam(value=BindObjectMetadataToRequest.class) ObjectMetadata var2, PutObjectOptions ... var3);

    @Named(value="s3:AbortMultipartUpload")
    @DELETE
    @Path(value="/{key}")
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    public ListenableFuture<Void> abortMultipartUpload(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") String var2, @QueryParam(value="uploadId") String var3);

    @Named(value="s3:PutObject")
    @PUT
    @Path(value="/{key}")
    @ResponseParser(value=ParseETagHeader.class)
    public ListenableFuture<String> uploadPart(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") String var2, @QueryParam(value="partNumber") int var3, @QueryParam(value="uploadId") String var4, Payload var5);

    @Named(value="s3:PutObject")
    @POST
    @Path(value="/{key}")
    @ResponseParser(value=ETagFromHttpResponseViaRegex.class)
    public ListenableFuture<String> completeMultipartUpload(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") String var2, @QueryParam(value="uploadId") String var3, @BinderParam(value=BindPartIdsAndETagsToRequest.class) Map<Integer, String> var4);

    @Named(value="s3:DeleteObject")
    @POST
    @Path(value="/")
    @QueryParams(keys={"delete"})
    @XMLResponseParser(value=DeleteResultHandler.class)
    public ListenableFuture<DeleteResult> deleteObjects(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @BinderParam(value=BindIterableAsPayloadToDeleteRequest.class) Iterable<String> var2);
}

