/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.filters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.Uris;
import org.jclouds.http.internal.SignatureWire;
import org.jclouds.http.utils.Queries;
import org.jclouds.io.InputSuppliers;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;
import org.jclouds.rest.RequestSigner;
import org.jclouds.util.Strings2;

@Singleton
public class QuerySigner
implements AuthenticationFilter,
RequestSigner {
    private final SignatureWire signatureWire;
    private final Supplier<Credentials> creds;
    private final Crypto crypto;
    private final HttpUtils utils;
    @Resource
    @Named(value="jclouds.signature")
    private Logger signatureLog = Logger.NULL;

    @Inject
    public QuerySigner(SignatureWire signatureWire, @Provider Supplier<Credentials> creds, Crypto crypto, HttpUtils utils) {
        this.signatureWire = signatureWire;
        this.creds = creds;
        this.crypto = crypto;
        this.utils = utils;
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        Preconditions.checkNotNull(request, "request must be present");
        Multimap<String, String> decodedParams = Queries.queryParser().apply(request.getEndpoint().getRawQuery());
        this.addSigningParams(decodedParams);
        String stringToSign = this.createStringToSign(request, decodedParams);
        String signature = this.sign(stringToSign);
        this.addSignature(decodedParams, signature);
        request = ((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).endpoint(Uris.uriBuilder(request.getEndpoint()).query(decodedParams).build())).build();
        this.utils.logRequest(this.signatureLog, request, "<<");
        return request;
    }

    @VisibleForTesting
    void addSignature(Multimap<String, String> params, String signature) {
        params.replaceValues("signature", ImmutableList.of(signature));
    }

    @Override
    @VisibleForTesting
    public String sign(String stringToSign) {
        try {
            String signature = CryptoStreams.base64(CryptoStreams.mac(InputSuppliers.of(stringToSign), this.crypto.hmacSHA1(this.creds.get().credential.getBytes())));
            if (this.signatureWire.enabled()) {
                this.signatureWire.input(Strings2.toInputStream(signature));
            }
            return signature;
        }
        catch (InvalidKeyException e) {
            throw Throwables.propagate(e);
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    @VisibleForTesting
    public String createStringToSign(HttpRequest request, Multimap<String, String> decodedParams) {
        this.utils.logRequest(this.signatureLog, request, ">>");
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        for (Map.Entry<String, String> entry : decodedParams.entries()) {
            builder.add(entry.getKey() + "=" + Strings2.urlEncode(entry.getValue(), new char[0]));
        }
        String stringToSign = Joiner.on('&').join(builder.build()).toLowerCase();
        if (this.signatureWire.enabled()) {
            this.signatureWire.output(stringToSign);
        }
        return stringToSign;
    }

    @VisibleForTesting
    void addSigningParams(Multimap<String, String> params) {
        params.replaceValues("apiKey", ImmutableList.of(this.creds.get().identity));
        params.removeAll("signature");
    }

    @Override
    public String createStringToSign(HttpRequest input) {
        Multimap<String, String> decodedParams = Queries.queryParser().apply(input.getEndpoint().getQuery());
        this.addSigningParams(decodedParams);
        return this.createStringToSign(input, decodedParams);
    }
}

