/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class CreateFirewallRuleOptions
extends BaseHttpRequestOptions {
    public static final CreateFirewallRuleOptions NONE = new CreateFirewallRuleOptions();

    public CreateFirewallRuleOptions CIDRs(Set<String> CIDRs) {
        this.queryParameters.replaceValues("cidrlist", ImmutableSet.of(Joiner.on(",").join(CIDRs)));
        return this;
    }

    public CreateFirewallRuleOptions startPort(int startPort) {
        this.queryParameters.replaceValues("startport", ImmutableSet.of(startPort + ""));
        return this;
    }

    public CreateFirewallRuleOptions endPort(int endPort) {
        this.queryParameters.replaceValues("endport", ImmutableSet.of(endPort + ""));
        return this;
    }

    public CreateFirewallRuleOptions icmpCode(String icmpCode) {
        this.queryParameters.replaceValues("icmpcode", ImmutableSet.of(icmpCode));
        return this;
    }

    public CreateFirewallRuleOptions icmpType(String icmpType) {
        this.queryParameters.replaceValues("icmptype", ImmutableSet.of(icmpType));
        return this;
    }

    public static class Builder {
        public static CreateFirewallRuleOptions CIDRs(Set<String> CIDRs) {
            CreateFirewallRuleOptions options = new CreateFirewallRuleOptions();
            return options.CIDRs(CIDRs);
        }

        public static CreateFirewallRuleOptions startPort(int startPort) {
            CreateFirewallRuleOptions options = new CreateFirewallRuleOptions();
            return options.startPort(startPort);
        }

        public static CreateFirewallRuleOptions endPort(int endPort) {
            CreateFirewallRuleOptions options = new CreateFirewallRuleOptions();
            return options.endPort(endPort);
        }

        public static CreateFirewallRuleOptions icmpCode(String icmpCode) {
            CreateFirewallRuleOptions options = new CreateFirewallRuleOptions();
            return options.icmpCode(icmpCode);
        }

        public static CreateFirewallRuleOptions icmpType(String icmpType) {
            CreateFirewallRuleOptions options = new CreateFirewallRuleOptions();
            return options.icmpType(icmpType);
        }
    }
}

