/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.xml;

import java.net.URI;
import java.util.Map;
import org.jclouds.deltacloud.domain.Image;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ImageHandler
extends ParseSax.HandlerWithResult<Image> {
    private StringBuilder currentText = new StringBuilder();
    private URI href;
    private String id;
    private String ownerId;
    private String name;
    private String description;
    private String architecture;
    private Image image;

    @Override
    public Image getResult() {
        return this.image;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (qName.equals("image")) {
            String href = attributes.get("href");
            if (href != null) {
                this.href = URI.create(href);
            }
            this.id = attributes.get("id");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("owner_id")) {
            this.ownerId = this.currentText.toString().trim();
        } else if (qName.equalsIgnoreCase("name")) {
            this.name = this.currentText.toString().trim();
        } else if (qName.equalsIgnoreCase("description")) {
            this.description = this.currentText.toString().trim();
        } else if (qName.equalsIgnoreCase("architecture")) {
            this.architecture = this.currentText.toString().trim();
        } else if (qName.equalsIgnoreCase("image")) {
            this.image = new Image(this.href, this.id, this.ownerId, this.name, this.description, this.architecture);
            this.href = null;
            this.id = null;
            this.ownerId = null;
            this.name = null;
            this.description = null;
            this.architecture = null;
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

