/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.filters;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.location.Provider;

@Singleton
public class BasicAuthentication
implements HttpRequestFilter {
    private final Supplier<Credentials> creds;

    @Inject
    public BasicAuthentication(@Provider Supplier<Credentials> creds) {
        this.creds = Preconditions.checkNotNull(creds, "creds");
    }

    public static String basic(String user, String password) {
        return "Basic " + CryptoStreams.base64(String.format("%s:%s", Preconditions.checkNotNull(user, "user"), Preconditions.checkNotNull(password, "password")).getBytes());
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        Credentials currentCreds = Preconditions.checkNotNull(this.creds.get(), "credential supplier returned null");
        return ((HttpRequest.Builder)request.toBuilder().replaceHeader("Authorization", BasicAuthentication.basic(currentCreds.identity, currentCreds.credential))).build();
    }
}

