/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.functions.ReturnTrueOn404;
import org.jclouds.openstack.keystone.v2_0.domain.PaginatedCollection;
import org.jclouds.rest.ResourceNotFoundException;

@Singleton
public class ReturnEmptyPaginatedCollectionOnNotFoundOr404
implements Function<Exception, Object> {
    private final ReturnTrueOn404 rto404;

    @Inject
    private ReturnEmptyPaginatedCollectionOnNotFoundOr404(ReturnTrueOn404 rto404) {
        this.rto404 = Preconditions.checkNotNull(rto404, "rto404");
    }

    @Override
    public Object apply(Exception from) {
        Iterable<ResourceNotFoundException> throwables = Iterables.filter(Throwables.getCausalChain(from), ResourceNotFoundException.class);
        if (Iterables.size(throwables) >= 1) {
            return PaginatedCollection.EMPTY;
        }
        if (this.rto404.apply(from).booleanValue()) {
            return PaginatedCollection.EMPTY;
        }
        throw Throwables.propagate(from);
    }
}

