/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.cache.LoadingCache;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.FloatingIP;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneAndId;
import org.jclouds.openstack.nova.v2_0.extensions.FloatingIPApi;

public class RemoveFloatingIpFromNodeAndDeallocate
implements Function<ZoneAndId, ZoneAndId> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final NovaApi novaApi;
    private final LoadingCache<ZoneAndId, Iterable<? extends FloatingIP>> floatingIpCache;

    @Inject
    public RemoveFloatingIpFromNodeAndDeallocate(NovaApi novaApi, @Named(value="FLOATINGIP") LoadingCache<ZoneAndId, Iterable<? extends FloatingIP>> floatingIpCache) {
        this.novaApi = Preconditions.checkNotNull(novaApi, "novaApi");
        this.floatingIpCache = Preconditions.checkNotNull(floatingIpCache, "floatingIpCache");
    }

    @Override
    public ZoneAndId apply(ZoneAndId id) {
        FloatingIPApi floatingIpApi = this.novaApi.getFloatingIPExtensionForZone(id.getZone()).get();
        for (FloatingIP floatingIP : this.floatingIpCache.getUnchecked(id)) {
            this.logger.debug(">> removing floatingIp(%s) from node(%s)", floatingIP, id);
            floatingIpApi.removeFromServer(floatingIP.getIp(), id.getId());
            this.logger.debug(">> deallocating floatingIp(%s)", floatingIP);
            floatingIpApi.delete(floatingIP.getId());
        }
        this.floatingIpCache.invalidate(id);
        return id;
    }

    public String toString() {
        return Objects.toStringHelper("RemoveFloatingIpFromNodeAndDecreate").toString();
    }
}

