/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.options;

import com.google.common.base.Preconditions;
import java.util.Date;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class BaseListOptions
extends BaseHttpRequestOptions {
    public static final BaseListOptions NONE = new BaseListOptions();

    public BaseListOptions changesSince(Date ifModifiedSince) {
        this.queryParameters.put("changes-since", Preconditions.checkNotNull(ifModifiedSince, "ifModifiedSince").getTime() / 1000L + "");
        return this;
    }

    public BaseListOptions startAt(long offset) {
        Preconditions.checkState(offset >= 0L, "offset must be >= 0");
        this.queryParameters.put("offset", Long.toString(Preconditions.checkNotNull(offset, "offset")));
        return this;
    }

    public BaseListOptions maxResults(int limit) {
        Preconditions.checkState(limit >= 0, "limit must be >= 0");
        Preconditions.checkState(limit <= 10000, "limit must be <= 10000");
        this.queryParameters.put("limit", Integer.toString(limit));
        return this;
    }

    public static class Builder {
        public static BaseListOptions startAt(long prefix) {
            BaseListOptions options = new BaseListOptions();
            return options.startAt(prefix);
        }

        public static BaseListOptions maxResults(int maxKeys) {
            BaseListOptions options = new BaseListOptions();
            return options.maxResults(maxKeys);
        }

        public static BaseListOptions changesSince(Date since) {
            BaseListOptions options = new BaseListOptions();
            return options.changesSince(since);
        }
    }
}

