/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.handlers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.swift.CopyObjectException;
import org.jclouds.rest.AuthorizationException;

public class ParseSwiftErrorFromHttpResponse
implements HttpErrorHandler {
    @Resource
    protected Logger logger = Logger.NULL;
    public static final String PREFIX = "^/v[0-9][^/]*/[^/]+/";
    public static final Pattern CONTAINER_PATH = Pattern.compile("^/v[0-9][^/]*/[^/]+/([^/]+)$");
    public static final Pattern CONTAINER_KEY_PATH = Pattern.compile("^/v[0-9][^/]*/[^/]+/([^/]+)/(.*)");

    @Override
    public void handleError(HttpCommand command, HttpResponse response) {
        byte[] data = HttpUtils.closeClientButKeepContentStream(response);
        String message = data != null ? new String(data) : null;
        RuntimeException exception = message != null ? new HttpResponseException(command, response, message) : new HttpResponseException(command, response);
        message = message != null ? message : String.format("%s -> %s", command.getCurrentRequest().getRequestLine(), response.getStatusLine());
        switch (response.getStatusCode()) {
            case 401: {
                exception = new AuthorizationException(exception.getMessage(), exception);
                break;
            }
            case 404: {
                String sourcePath = command.getCurrentRequest().getFirstHeaderOrNull("X-Copy-From");
                HttpResponseException oldException = exception;
                if (sourcePath != null) {
                    String path = command.getCurrentRequest().getEndpoint().getPath();
                    int startOfDestinationPath = path.lastIndexOf("/", path.lastIndexOf("/") - 1);
                    String destinationPath = path.substring(startOfDestinationPath);
                    exception = new CopyObjectException(sourcePath, destinationPath, message);
                    exception.initCause(oldException);
                    break;
                }
                if (command.getCurrentRequest().getMethod().equals("DELETE")) break;
                String path = command.getCurrentRequest().getEndpoint().getPath();
                Matcher matcher = CONTAINER_PATH.matcher(path);
                if (matcher.find()) {
                    exception = new ContainerNotFoundException(matcher.group(1), message);
                    exception.initCause(oldException);
                    break;
                }
                matcher = CONTAINER_KEY_PATH.matcher(path);
                if (!matcher.find()) break;
                exception = new KeyNotFoundException(matcher.group(1), matcher.group(2), message);
                exception.initCause(oldException);
            }
        }
        command.setException(exception);
    }
}

