/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.internal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provides;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import javax.annotation.Resource;
import javax.inject.Singleton;
import javax.ws.rs.Path;
import org.jclouds.http.HttpRequest;
import org.jclouds.logging.Logger;
import org.jclouds.rest.annotations.Delegate;
import org.jclouds.rest.internal.RestAnnotationProcessor;

@Singleton
public class SeedAnnotationCache
extends CacheLoader<Class<?>, Boolean> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final Injector injector;
    protected final Cache<RestAnnotationProcessor.MethodKey, Method> delegationMap;

    @Inject
    public SeedAnnotationCache(Injector injector, Cache<RestAnnotationProcessor.MethodKey, Method> delegationMap) {
        this.injector = injector;
        this.delegationMap = delegationMap;
    }

    @Override
    public Boolean load(Class<?> declaring) throws ExecutionException {
        for (Method method : Sets.difference(ImmutableSet.copyOf(declaring.getMethods()), ImmutableSet.copyOf(Object.class.getMethods()))) {
            if (SeedAnnotationCache.isHttpMethod(method) || method.isAnnotationPresent(Delegate.class)) {
                for (int index = 0; index < method.getParameterTypes().length; ++index) {
                    RestAnnotationProcessor.methodToIndexOfParamToBinderParamAnnotation.get(method).get(index);
                    RestAnnotationProcessor.methodToIndexOfParamToWrapWithAnnotation.get(method).get(index);
                    RestAnnotationProcessor.methodToIndexOfParamToHeaderParamAnnotations.get(method).get(index);
                    RestAnnotationProcessor.methodToIndexOfParamToFormParamAnnotations.get(method).get(index);
                    RestAnnotationProcessor.methodToIndexOfParamToQueryParamAnnotations.get(method).get(index);
                    RestAnnotationProcessor.methodToIndexOfParamToEndpointAnnotations.get(method).get(index);
                    RestAnnotationProcessor.methodToIndexOfParamToEndpointParamAnnotations.get(method).get(index);
                    RestAnnotationProcessor.methodToIndexOfParamToPathParamAnnotations.get(method).get(index);
                    RestAnnotationProcessor.methodToIndexOfParamToPostParamAnnotations.get(method).get(index);
                    RestAnnotationProcessor.methodToIndexOfParamToParamParserAnnotations.get(method).get(index);
                    RestAnnotationProcessor.methodToIndexOfParamToPartParamAnnotations.get(method).get(index);
                    RestAnnotationProcessor.methodToIndexesOfOptions.get(method);
                }
                this.delegationMap.put(new RestAnnotationProcessor.MethodKey(method), method);
                continue;
            }
            if (!method.getDeclaringClass().equals(declaring)) {
                this.logger.trace("skipping potentially overridden method %s", method);
                continue;
            }
            if (method.isAnnotationPresent(Provides.class)) {
                this.logger.trace("skipping provider method %s", method);
                continue;
            }
            this.logger.trace("Method is not annotated as either http or provider method: %s", method);
        }
        return true;
    }

    public static boolean isHttpMethod(Method method) {
        return method.isAnnotationPresent(Path.class) || RestAnnotationProcessor.getHttpMethods(method) != null || ImmutableSet.copyOf(method.getParameterTypes()).contains(HttpRequest.class);
    }
}

