/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.Properties;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.internal.BaseApiMetadata;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.internal.BaseRestApiMetadata;
import org.jclouds.s3.S3AsyncClient;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.blobstore.S3BlobStoreContext;
import org.jclouds.s3.blobstore.config.S3BlobStoreContextModule;
import org.jclouds.s3.config.S3RestClientModule;

public class S3ApiMetadata
extends BaseRestApiMetadata {
    private static final long serialVersionUID = 820062881469203616L;
    public static final TypeToken<RestContext<? extends S3Client, ? extends S3AsyncClient>> CONTEXT_TOKEN = new TypeToken<RestContext<? extends S3Client, ? extends S3AsyncClient>>(){
        private static final long serialVersionUID = -5070937833892503232L;
    };

    @Override
    public Builder toBuilder() {
        return new Builder(this.getApi(), this.getAsyncApi()).fromApiMetadata(this);
    }

    public S3ApiMetadata() {
        this(new Builder(S3Client.class, S3AsyncClient.class));
    }

    protected S3ApiMetadata(Builder builder) {
        super(builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseRestApiMetadata.defaultProperties();
        properties.setProperty("jclouds.api-version", "2006-03-01");
        properties.setProperty("jclouds.aws.auth.tag", "AWS");
        properties.setProperty("jclouds.aws.header.tag", "amz");
        properties.setProperty("jclouds.s3.service-path", "/");
        properties.setProperty("jclouds.s3.virtual-host-buckets", "true");
        properties.setProperty("jclouds.relax-hostname", "true");
        properties.setProperty("jclouds.blobstore.directorysuffix", "_$folder$");
        properties.setProperty("jclouds.blobstore.metaprefix", String.format("x-${%s}-meta-", "jclouds.aws.header.tag"));
        return properties;
    }

    public static class Builder
    extends BaseRestApiMetadata.Builder {
        protected Builder(Class<?> syncClient, Class<?> asyncClient) {
            super(syncClient, asyncClient);
            ((BaseApiMetadata.Builder)((BaseApiMetadata.Builder)this.id("s3").name("Amazon Simple Storage Service (S3) API").identityName("Access Key ID").credentialName("Secret Access Key").defaultEndpoint("https://s3.amazonaws.com").documentation(URI.create("http://docs.amazonwebservices.com/AmazonS3/latest/API")).version("2006-03-01").defaultProperties(S3ApiMetadata.defaultProperties()).context(CONTEXT_TOKEN)).view(TypeToken.of(S3BlobStoreContext.class))).defaultModules(ImmutableSet.of(S3RestClientModule.class, S3BlobStoreContextModule.class));
        }

        @Override
        public ApiMetadata build() {
            return new S3ApiMetadata(this);
        }

        @Override
        public Builder fromApiMetadata(ApiMetadata in) {
            super.fromApiMetadata(in);
            return this;
        }
    }
}

