/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3;

import com.google.inject.Provides;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jclouds.concurrent.Timeout;
import org.jclouds.http.options.GetOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.s3.Bucket;
import org.jclouds.s3.domain.AccessControlList;
import org.jclouds.s3.domain.BucketLogging;
import org.jclouds.s3.domain.BucketMetadata;
import org.jclouds.s3.domain.ListBucketResponse;
import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.s3.domain.Payer;
import org.jclouds.s3.domain.S3Object;
import org.jclouds.s3.options.CopyObjectOptions;
import org.jclouds.s3.options.ListBucketOptions;
import org.jclouds.s3.options.PutBucketOptions;
import org.jclouds.s3.options.PutObjectOptions;

@Timeout(duration=90L, timeUnit=TimeUnit.SECONDS)
public interface S3Client {
    @Provides
    public S3Object newS3Object();

    @Timeout(duration=10240L, timeUnit=TimeUnit.SECONDS)
    public S3Object getObject(String var1, String var2, GetOptions ... var3);

    public ObjectMetadata headObject(String var1, String var2);

    public boolean objectExists(String var1, String var2);

    public void deleteObject(String var1, String var2);

    @Timeout(duration=40960L, timeUnit=TimeUnit.SECONDS)
    public String putObject(String var1, S3Object var2, PutObjectOptions ... var3);

    @Timeout(duration=90L, timeUnit=TimeUnit.SECONDS)
    public boolean putBucketInRegion(@Nullable String var1, @Bucket String var2, PutBucketOptions ... var3);

    public boolean deleteBucketIfEmpty(String var1);

    public boolean bucketExists(String var1);

    public ListBucketResponse listBucket(String var1, ListBucketOptions ... var2);

    public Set<BucketMetadata> listOwnedBuckets();

    @Timeout(duration=10L, timeUnit=TimeUnit.MINUTES)
    public ObjectMetadata copyObject(String var1, String var2, String var3, String var4, CopyObjectOptions ... var5);

    public AccessControlList getBucketACL(String var1);

    public boolean putBucketACL(String var1, AccessControlList var2);

    public AccessControlList getObjectACL(String var1, String var2);

    public boolean putObjectACL(String var1, String var2, AccessControlList var3);

    public String getBucketLocation(String var1);

    public Payer getBucketPayer(String var1);

    public void setBucketPayer(String var1, Payer var2);

    public BucketLogging getBucketLogging(String var1);

    public void enableBucketLogging(String var1, BucketLogging var2);

    public void disableBucketLogging(String var1);
}

