/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.domain;

public enum CannedAccessPolicy {
    PRIVATE("private"),
    PUBLIC_READ("public-read"),
    PUBLIC_READ_WRITE("public-read-write"),
    AUTHENTICATED_READ("authenticated-read");

    private String policyName;

    private CannedAccessPolicy(String policyName) {
        this.policyName = policyName;
    }

    public String toString() {
        return this.policyName;
    }

    public static CannedAccessPolicy fromHeader(String capHeader) {
        if ("private".equals(capHeader)) {
            return PRIVATE;
        }
        if ("public-read".equals(capHeader)) {
            return PUBLIC_READ;
        }
        if ("public-read-write".equals(capHeader)) {
            return PUBLIC_READ_WRITE;
        }
        if ("authenticated-read".equals(capHeader)) {
            return AUTHENTICATED_READ;
        }
        return null;
    }
}

