/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.config;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Scopes;
import java.util.Map;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.location.config.LocationModule;
import org.jclouds.location.suppliers.ImplicitLocationSupplier;
import org.jclouds.location.suppliers.implicit.OnlyLocationOrFirstZone;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.config.RestClientModule;
import org.jclouds.softlayer.SoftLayerAsyncClient;
import org.jclouds.softlayer.SoftLayerClient;
import org.jclouds.softlayer.config.SoftLayerParserModule;
import org.jclouds.softlayer.features.AccountAsyncClient;
import org.jclouds.softlayer.features.AccountClient;
import org.jclouds.softlayer.features.DatacenterAsyncClient;
import org.jclouds.softlayer.features.DatacenterClient;
import org.jclouds.softlayer.features.ProductPackageAsyncClient;
import org.jclouds.softlayer.features.ProductPackageClient;
import org.jclouds.softlayer.features.VirtualGuestAsyncClient;
import org.jclouds.softlayer.features.VirtualGuestClient;
import org.jclouds.softlayer.handlers.SoftLayerErrorHandler;

@ConfiguresRestClient
public class SoftLayerRestClientModule
extends RestClientModule<SoftLayerClient, SoftLayerAsyncClient> {
    public static final Map<Class<?>, Class<?>> DELEGATE_MAP = ImmutableMap.builder().put(VirtualGuestClient.class, VirtualGuestAsyncClient.class).put(DatacenterClient.class, DatacenterAsyncClient.class).put(ProductPackageClient.class, ProductPackageAsyncClient.class).put(AccountClient.class, AccountAsyncClient.class).build();

    public SoftLayerRestClientModule() {
        super(DELEGATE_MAP);
    }

    @Override
    protected void configure() {
        this.install(new SoftLayerParserModule());
        super.configure();
    }

    @Override
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(SoftLayerErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(SoftLayerErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(SoftLayerErrorHandler.class);
    }

    @Override
    protected void bindRetryHandlers() {
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(BackoffLimitedRetryHandler.class);
    }

    @Override
    protected void installLocations() {
        this.install(new LocationModule());
        this.bind(ImplicitLocationSupplier.class).to(OnlyLocationOrFirstZone.class).in(Scopes.SINGLETON);
    }
}

