/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sts;

import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.Properties;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.internal.BaseRestApiMetadata;
import org.jclouds.sts.STSApi;
import org.jclouds.sts.STSAsyncApi;
import org.jclouds.sts.config.STSRestClientModule;

public class STSApiMetadata
extends BaseRestApiMetadata {
    public static final TypeToken<RestContext<? extends STSApi, ? extends STSAsyncApi>> CONTEXT_TOKEN = new TypeToken<RestContext<? extends STSApi, ? extends STSAsyncApi>>(){
        private static final long serialVersionUID = 1L;
    };

    @Override
    public Builder toBuilder() {
        return new Builder(this.getApi(), this.getAsyncApi()).fromApiMetadata(this);
    }

    public STSApiMetadata() {
        this(new Builder(STSApi.class, STSAsyncApi.class));
    }

    protected STSApiMetadata(Builder builder) {
        super((BaseRestApiMetadata.Builder)Builder.class.cast(builder));
    }

    public static Properties defaultProperties() {
        Properties properties = BaseRestApiMetadata.defaultProperties();
        properties.setProperty("jclouds.aws.auth.tag", "AWS");
        properties.setProperty("jclouds.aws.header.tag", "amz");
        return properties;
    }

    public static class Builder
    extends BaseRestApiMetadata.Builder {
        protected Builder(Class<?> api, Class<?> asyncApi) {
            super(api, asyncApi);
            this.id("sts").name("Amazon STS Api").identityName("Access Key ID").credentialName("Secret Access Key").version("2011-06-15").documentation(URI.create("http://docs.amazonwebservices.com/STS/latest/APIReference/")).defaultEndpoint("https://sts.amazonaws.com").defaultProperties(STSApiMetadata.defaultProperties()).defaultModule(STSRestClientModule.class);
        }

        @Override
        public STSApiMetadata build() {
            return new STSApiMetadata(this);
        }

        @Override
        public Builder fromApiMetadata(ApiMetadata in) {
            super.fromApiMetadata(in);
            return this;
        }
    }
}

