/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.binders;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.jamesmurty.utils.XMLBuilder;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jclouds.http.HttpRequest;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToStringPayload;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.VAppTemplate;
import org.jclouds.vcloud.domain.Vm;
import org.jclouds.vcloud.domain.network.FenceMode;
import org.jclouds.vcloud.domain.network.NetworkConfig;
import org.jclouds.vcloud.endpoints.Network;
import org.jclouds.vcloud.options.InstantiateVAppTemplateOptions;

@Singleton
public class BindInstantiateVAppTemplateParamsToXmlPayload
implements MapBinder {
    protected final String ns;
    protected final String schema;
    protected final BindToStringPayload stringBinder;
    protected final Supplier<ReferenceType> defaultNetwork;
    protected final FenceMode defaultFenceMode;
    protected final LoadingCache<URI, VAppTemplate> templateCache;
    protected final Function<VAppTemplate, String> defaultNetworkNameInTemplate;

    @Inject
    public BindInstantiateVAppTemplateParamsToXmlPayload(LoadingCache<URI, VAppTemplate> templateCache, @Network Function<VAppTemplate, String> defaultNetworkNameInTemplate, BindToStringPayload stringBinder, @Named(value="jclouds.vcloud.xml.ns") String ns, @Named(value="jclouds.vcloud.xml.schema") String schema, @Network Supplier<ReferenceType> network, FenceMode fenceMode) {
        this.templateCache = templateCache;
        this.defaultNetworkNameInTemplate = defaultNetworkNameInTemplate;
        this.ns = ns;
        this.schema = schema;
        this.stringBinder = stringBinder;
        this.defaultNetwork = network;
        this.defaultFenceMode = fenceMode;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Preconditions.checkArgument(Preconditions.checkNotNull(request, "request") instanceof GeneratedHttpRequest, "this binder is only valid for GeneratedHttpRequests!");
        GeneratedHttpRequest gRequest = (GeneratedHttpRequest)request;
        Preconditions.checkState(gRequest.getArgs() != null, "args should be initialized at this point");
        String name = Preconditions.checkNotNull(postParams.remove("name"), "name").toString();
        URI template = URI.create(Preconditions.checkNotNull(postParams.remove("template"), "template").toString());
        ImmutableSet<NetworkConfig> networkConfig = null;
        NetworkConfigDecorator networkConfigDecorator = new NetworkConfigDecorator(this.templateCache.getUnchecked(template), this.defaultNetwork.get().getHref(), this.defaultFenceMode, this.defaultNetworkNameInTemplate);
        InstantiateVAppTemplateOptions options = this.findOptionsInArgsOrNull(gRequest);
        if (options != null) {
            if (options.getNetworkConfig().size() > 0) {
                networkConfig = ImmutableSet.copyOf(Iterables.transform(options.getNetworkConfig(), networkConfigDecorator));
            }
        } else {
            options = new InstantiateVAppTemplateOptions();
        }
        if (networkConfig == null) {
            networkConfig = ImmutableSet.of(networkConfigDecorator.apply(null));
        }
        try {
            return this.stringBinder.bindToRequest(request, this.generateXml(name, options.getDescription(), options.shouldDeploy(), options.shouldPowerOn(), template, networkConfig));
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    Set<Vm> ifCustomizationScriptIsSetGetVmsInTemplate(String customizationScript, URI template) {
        Set<Vm> vms = ImmutableSet.of();
        if (customizationScript != null) {
            VAppTemplate vAppTemplate = this.templateCache.getUnchecked(template);
            Preconditions.checkArgument(vAppTemplate != null, "vAppTemplate %s not found!", template);
            vms = vAppTemplate.getChildren();
            Preconditions.checkArgument(vms.size() > 0, "no vms found in vAppTemplate %s", vAppTemplate);
        }
        return vms;
    }

    protected String generateXml(String name, @Nullable String description, boolean deploy, boolean powerOn, URI template, Iterable<NetworkConfig> networkConfig) throws ParserConfigurationException, FactoryConfigurationError, TransformerException {
        XMLBuilder rootBuilder = this.buildRoot(name).a("deploy", deploy + "").a("powerOn", powerOn + "");
        if (description != null) {
            rootBuilder.e("Description").t(description);
        }
        XMLBuilder instantiationParamsBuilder = rootBuilder.e("InstantiationParams");
        this.addNetworkConfig(instantiationParamsBuilder, networkConfig);
        rootBuilder.e("Source").a("href", template.toASCIIString());
        rootBuilder.e("AllEULAsAccepted").t("true");
        Properties outputProperties = new Properties();
        outputProperties.put("omit-xml-declaration", "yes");
        return rootBuilder.asString(outputProperties);
    }

    protected void addNetworkConfig(XMLBuilder instantiationParamsBuilder, Iterable<NetworkConfig> networkConfig) {
        XMLBuilder networkConfigBuilder = instantiationParamsBuilder.e("NetworkConfigSection");
        networkConfigBuilder.e("ovf:Info").t("Configuration parameters for logical networks");
        for (NetworkConfig n : networkConfig) {
            XMLBuilder configurationBuilder = networkConfigBuilder.e("NetworkConfig").a("networkName", n.getNetworkName()).e("Configuration");
            configurationBuilder.e("ParentNetwork").a("href", n.getParentNetwork().toASCIIString());
            if (n.getFenceMode() == null) continue;
            configurationBuilder.e("FenceMode").t(n.getFenceMode().toString());
        }
    }

    protected XMLBuilder buildRoot(String name) throws ParserConfigurationException, FactoryConfigurationError {
        return XMLBuilder.create("InstantiateVAppTemplateParams").a("name", name).a("xmlns", this.ns).a("xmlns:ovf", "http://schemas.dmtf.org/ovf/envelope/1");
    }

    protected InstantiateVAppTemplateOptions findOptionsInArgsOrNull(GeneratedHttpRequest gRequest) {
        for (Object arg : gRequest.getArgs()) {
            if (arg instanceof InstantiateVAppTemplateOptions) {
                return (InstantiateVAppTemplateOptions)arg;
            }
            if (!(arg instanceof InstantiateVAppTemplateOptions[])) continue;
            InstantiateVAppTemplateOptions[] options = (InstantiateVAppTemplateOptions[])arg;
            return options.length > 0 ? options[0] : null;
        }
        return null;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new IllegalStateException("InstantiateVAppTemplateParams is needs parameters");
    }

    public static <T> T ifNullDefaultTo(T value, T defaultValue) {
        return value != null ? value : Preconditions.checkNotNull(defaultValue, "defaultValue");
    }

    protected static final class NetworkConfigDecorator
    implements Function<NetworkConfig, NetworkConfig> {
        private final VAppTemplate template;
        private final URI defaultNetwork;
        private final FenceMode defaultFenceMode;
        private final Function<VAppTemplate, String> defaultNetworkNameInTemplate;

        protected NetworkConfigDecorator(VAppTemplate template, URI defaultNetwork, FenceMode defaultFenceMode, Function<VAppTemplate, String> defaultNetworkNameInTemplate) {
            this.template = Preconditions.checkNotNull(template, "template");
            this.defaultNetwork = Preconditions.checkNotNull(defaultNetwork, "defaultNetwork");
            this.defaultFenceMode = Preconditions.checkNotNull(defaultFenceMode, "defaultFenceMode");
            this.defaultNetworkNameInTemplate = Preconditions.checkNotNull(defaultNetworkNameInTemplate, "defaultNetworkNameInTemplate");
        }

        @Override
        public NetworkConfig apply(NetworkConfig from) {
            if (from == null) {
                return new NetworkConfig(this.defaultNetworkNameInTemplate.apply(this.template), this.defaultNetwork, this.defaultFenceMode);
            }
            URI network = BindInstantiateVAppTemplateParamsToXmlPayload.ifNullDefaultTo(from.getParentNetwork(), this.defaultNetwork);
            FenceMode fenceMode = BindInstantiateVAppTemplateParamsToXmlPayload.ifNullDefaultTo(from.getFenceMode(), this.defaultFenceMode);
            String networkName = from.getNetworkName() != null ? from.getNetworkName() : this.defaultNetworkNameInTemplate.apply(this.template);
            return new NetworkConfig(networkName, network, fenceMode);
        }
    }
}

