/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.vcloud.VCloudToken;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.VCloudSession;
import org.jclouds.vcloud.endpoints.Org;
import org.jclouds.vcloud.xml.OrgListHandler;

@Singleton
public class ParseLoginResponseFromHeaders
implements Function<HttpResponse, VCloudSession> {
    static final Pattern pattern = Pattern.compile("(vcloud-token)=?([^;]+)(;.*)?");
    private final ParseSax.Factory factory;
    private final Provider<OrgListHandler> orgHandlerProvider;

    @Inject
    private ParseLoginResponseFromHeaders(ParseSax.Factory factory, Provider<OrgListHandler> orgHandlerProvider) {
        this.factory = factory;
        this.orgHandlerProvider = orgHandlerProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VCloudSession apply(HttpResponse from) {
        try {
            final String token = this.parseTokenFromHeaders(from);
            final Map org = (Map)this.factory.create(this.orgHandlerProvider.get()).parse(Preconditions.checkNotNull(from.getPayload().getInput(), "no payload in http response to login request %s", from));
            VCloudSession vCloudSession = new VCloudSession(){

                @Override
                @VCloudToken
                public String getVCloudToken() {
                    return token;
                }

                @Override
                @Org
                public Map<String, ReferenceType> getOrgs() {
                    return org;
                }
            };
            return vCloudSession;
        }
        finally {
            HttpUtils.releasePayload(from);
        }
    }

    public String parseTokenFromHeaders(HttpResponse from) {
        String cookieHeader = from.getFirstHeaderOrNull("x-vcloud-authorization");
        if (cookieHeader != null) {
            Matcher matcher = pattern.matcher(cookieHeader);
            return matcher.find() ? matcher.group(2) : cookieHeader;
        }
        try {
            cookieHeader = (String)Iterables.find(from.getHeaders().get("Set-Cookie"), Predicates.contains(pattern));
            Matcher matcher = pattern.matcher(cookieHeader);
            matcher.find();
            return matcher.group(2);
        }
        catch (NoSuchElementException e) {
            throw new HttpResponseException(String.format("Header %s or %s must be present", "x-vcloud-authorization", "Set-Cookie"), null, from);
        }
    }
}

