/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.VAppTemplate;

@Singleton
public class VAppTemplatesSupplier
implements Supplier<Set<VAppTemplate>> {
    @Resource
    @Named(value="jclouds.compute")
    public Logger logger = Logger.NULL;
    private final Supplier<Map<String, Org>> orgMap;
    private final Function<Org, Iterable<VAppTemplate>> imagesInOrg;
    private final ExecutorService executor;

    @Inject
    VAppTemplatesSupplier(Supplier<Map<String, Org>> orgMap, Function<Org, Iterable<VAppTemplate>> imagesInOrg, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.orgMap = Preconditions.checkNotNull(orgMap, "orgMap");
        this.imagesInOrg = Preconditions.checkNotNull(imagesInOrg, "imagesInOrg");
        this.executor = Preconditions.checkNotNull(executor, "executor");
    }

    @Override
    public Set<VAppTemplate> get() {
        Iterable orgs = Preconditions.checkNotNull(this.orgMap.get().values(), "orgs");
        Iterable<? extends Iterable<VAppTemplate>> images = FutureIterables.transformParallel(orgs, new Function<Org, Future<? extends Iterable<VAppTemplate>>>(){

            @Override
            public Future<Iterable<VAppTemplate>> apply(final Org from) {
                Preconditions.checkNotNull(from, "org");
                return VAppTemplatesSupplier.this.executor.submit(new Callable<Iterable<VAppTemplate>>(){

                    @Override
                    public Iterable<VAppTemplate> call() throws Exception {
                        return (Iterable)VAppTemplatesSupplier.this.imagesInOrg.apply(from);
                    }

                    public String toString() {
                        return "imagesInOrg(" + from.getHref() + ")";
                    }
                });
            }
        }, this.executor, null, this.logger, "images in " + orgs);
        return Sets.newLinkedHashSet(Iterables.concat(images));
    }
}

