/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.method;

import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.method.KeyedAuthMethod;

public class AuthPublickey
extends KeyedAuthMethod {
    public AuthPublickey(KeyProvider kProv) {
        super("publickey", kProv);
    }

    @Override
    public void handle(Message cmd, SSHPacket buf) throws UserAuthException, TransportException {
        if (cmd == Message.USERAUTH_60) {
            this.sendSignedReq();
        } else {
            super.handle(cmd, buf);
        }
    }

    private SSHPacket buildReq(boolean signed) throws UserAuthException {
        this.log.debug("Attempting authentication using {}", this.kProv);
        return this.putPubKey((SSHPacket)super.buildReq().putBoolean(signed));
    }

    private void sendSignedReq() throws UserAuthException, TransportException {
        this.log.debug("Key acceptable, sending signed request");
        this.params.getTransport().write(this.putSig(this.buildReq(true)));
    }

    @Override
    protected SSHPacket buildReq() throws UserAuthException {
        return this.buildReq(false);
    }
}

