/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service.jclouds.firewall.internal;

import java.util.HashMap;
import java.util.Map;
import org.fusesource.fabric.service.jclouds.firewall.FirewallManager;
import org.fusesource.fabric.service.jclouds.firewall.FirewallManagerFactory;
import org.fusesource.fabric.service.jclouds.firewall.FirewallNotSupportedOnProviderException;
import org.fusesource.fabric.service.jclouds.firewall.ProviderFirewallSupport;
import org.jclouds.compute.ComputeService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class FirewallManagerFactoryImpl
implements FirewallManagerFactory {
    private final Map<String, ProviderFirewallSupport> support = new HashMap<String, ProviderFirewallSupport>();
    private final Map<String, FirewallManager> managers = new HashMap<String, FirewallManager>();
    private BundleContext bundleContext;
    private ServiceTracker firewallSupportModuleTracker;

    public void init() {
        this.firewallSupportModuleTracker = new ServiceTracker(this.bundleContext, ProviderFirewallSupport.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                ProviderFirewallSupport support = (ProviderFirewallSupport)FirewallManagerFactoryImpl.this.bundleContext.getService(reference);
                FirewallManagerFactoryImpl.this.bind(support);
                return support;
            }

            public void removedService(ServiceReference reference, Object service) {
                ProviderFirewallSupport support = (ProviderFirewallSupport)service;
                FirewallManagerFactoryImpl.this.unbind(support);
                super.removedService(reference, service);
            }

            public void modifiedService(ServiceReference reference, Object service) {
                ProviderFirewallSupport support = (ProviderFirewallSupport)service;
                FirewallManagerFactoryImpl.this.bind(support);
                super.modifiedService(reference, service);
            }
        };
        this.firewallSupportModuleTracker.open();
    }

    public void destroy() {
        if (this.firewallSupportModuleTracker != null) {
            this.firewallSupportModuleTracker.close();
        }
    }

    @Override
    public synchronized FirewallManager getFirewallManager(ComputeService computeService) throws FirewallNotSupportedOnProviderException {
        FirewallManager firewallManager = null;
        String provider = computeService.getContext().unwrap().getId();
        firewallManager = this.managers.get(provider);
        if (firewallManager == null) {
            ProviderFirewallSupport firewallSupport = this.support.get(provider);
            if (firewallSupport == null) {
                throw new FirewallNotSupportedOnProviderException("Provider " + provider + " is currently not supported for firewall operations");
            }
            firewallManager = new FirewallManager(computeService, firewallSupport);
            this.managers.put(provider, firewallManager);
        }
        return firewallManager;
    }

    public void bind(ProviderFirewallSupport providerSupport) {
        if (providerSupport != null && providerSupport.getProviders() != null) {
            for (String provider : providerSupport.getProviders()) {
                this.support.put(provider, providerSupport);
            }
        }
    }

    public void unbind(ProviderFirewallSupport providerSupport) {
        if (providerSupport != null && providerSupport.getProviders() != null) {
            for (String provider : providerSupport.getProviders()) {
                this.support.remove(provider);
            }
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

