/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.jclouds.aws.ec2.domain.MonitoringState;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.ec2.domain.Hypervisor;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.RootDeviceType;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.javax.annotation.Nullable;

public class AWSRunningInstance
extends RunningInstance {
    private final MonitoringState monitoringState;
    @Nullable
    private final String placementGroup;
    private final Set<String> productCodes;
    @Nullable
    private final String subnetId;
    @Nullable
    private final String spotInstanceRequestId;
    @Nullable
    private final String vpcId;
    private final Hypervisor hypervisor;
    private final Map<String, String> securityGroupIdToNames;
    private final Map<String, String> tags;

    public static Builder builder() {
        return new Builder();
    }

    protected AWSRunningInstance(String region, Map<String, String> securityGroupIdToNames, String amiLaunchIndex, String dnsName, String imageId, String instanceId, InstanceState instanceState, String rawState, String instanceType, String ipAddress, String kernelId, String keyName, Date launchTime, String availabilityZone, String virtualizationType, String platform, String privateDnsName, String privateIpAddress, String ramdiskId, String reason, RootDeviceType rootDeviceType, String rootDeviceName, Map<String, BlockDevice> ebsBlockDevices, MonitoringState monitoringState, String placementGroup, Iterable<String> productCodes, String subnetId, String spotInstanceRequestId, String vpcId, Hypervisor hypervisor, Map<String, String> tags) {
        super(region, securityGroupIdToNames.values(), amiLaunchIndex, dnsName, imageId, instanceId, instanceState, rawState, instanceType, ipAddress, kernelId, keyName, launchTime, availabilityZone, virtualizationType, platform, privateDnsName, privateIpAddress, ramdiskId, reason, rootDeviceType, rootDeviceName, ebsBlockDevices);
        this.monitoringState = Preconditions.checkNotNull(monitoringState, "monitoringState");
        this.placementGroup = placementGroup;
        this.productCodes = ImmutableSet.copyOf(Preconditions.checkNotNull(productCodes, "productCodes"));
        this.subnetId = subnetId;
        this.spotInstanceRequestId = spotInstanceRequestId;
        this.vpcId = vpcId;
        this.hypervisor = Preconditions.checkNotNull(hypervisor, "hypervisor");
        this.securityGroupIdToNames = ImmutableMap.copyOf(Preconditions.checkNotNull(securityGroupIdToNames, "securityGroupIdToNames"));
        this.tags = ImmutableMap.copyOf(Preconditions.checkNotNull(tags, "tags"));
    }

    public Map<String, String> getSecurityGroupIdToNames() {
        return this.securityGroupIdToNames;
    }

    public MonitoringState getMonitoringState() {
        return this.monitoringState;
    }

    public String getPlacementGroup() {
        return this.placementGroup;
    }

    public Set<String> getProductCodes() {
        return this.productCodes;
    }

    public String getSpotInstanceRequestId() {
        return this.spotInstanceRequestId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public Hypervisor getHypervisor() {
        return this.hypervisor;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("monitoringState", (Object)this.monitoringState).add("placementGroup", this.placementGroup).add("subnetId", this.subnetId).add("spotInstanceRequestId", this.spotInstanceRequestId).add("vpcId", this.vpcId).add("hypervisor", (Object)this.hypervisor).add("tags", this.tags);
    }

    public static class Builder
    extends RunningInstance.Builder {
        private MonitoringState monitoringState;
        private String placementGroup;
        private Set<String> productCodes = Sets.newLinkedHashSet();
        private String subnetId;
        private String spotInstanceRequestId;
        private String vpcId;
        private Hypervisor hypervisor;
        private Map<String, String> securityGroupIdToNames = Maps.newLinkedHashMap();
        private Map<String, String> tags = Maps.newLinkedHashMap();

        public Builder tags(Map<String, String> tags) {
            this.tags = ImmutableMap.copyOf(Preconditions.checkNotNull(tags, "tags"));
            return this;
        }

        public Builder tag(String key, String value) {
            if (key != null) {
                this.tags.put(key, Strings.nullToEmpty(value));
            }
            return this;
        }

        public Builder securityGroupIdToNames(Map<String, String> securityGroupIdToNames) {
            this.securityGroupIdToNames = ImmutableMap.copyOf(Preconditions.checkNotNull(securityGroupIdToNames, "securityGroupIdToNames"));
            return this;
        }

        public Builder securityGroupIdToName(String key, String value) {
            if (key != null && value != null) {
                this.securityGroupIdToNames.put(key, value);
            }
            return this;
        }

        public Builder monitoringState(MonitoringState monitoringState) {
            this.monitoringState = monitoringState;
            return this;
        }

        public Builder placementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        public Builder productCodes(Iterable<String> productCodes) {
            this.productCodes = ImmutableSet.copyOf(Preconditions.checkNotNull(productCodes, "productCodes"));
            return this;
        }

        public Builder productCode(String productCode) {
            if (productCode != null) {
                this.productCodes.add(productCode);
            }
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public Builder spotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
            return this;
        }

        public Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public Builder hypervisor(Hypervisor hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        @Override
        public Builder amiLaunchIndex(String amiLaunchIndex) {
            return (Builder)Builder.class.cast(super.amiLaunchIndex(amiLaunchIndex));
        }

        @Override
        public Builder availabilityZone(String availabilityZone) {
            return (Builder)Builder.class.cast(super.availabilityZone(availabilityZone));
        }

        @Override
        public Builder devices(Map<String, BlockDevice> ebsBlockDevices) {
            return (Builder)Builder.class.cast(super.devices(ebsBlockDevices));
        }

        @Override
        public Builder dnsName(String dnsName) {
            return (Builder)Builder.class.cast(super.dnsName(dnsName));
        }

        @Override
        public Builder imageId(String imageId) {
            return (Builder)Builder.class.cast(super.imageId(imageId));
        }

        @Override
        public Builder instanceId(String instanceId) {
            return (Builder)Builder.class.cast(super.instanceId(instanceId));
        }

        @Override
        public Builder instanceState(InstanceState instanceState) {
            return (Builder)Builder.class.cast(super.instanceState(instanceState));
        }

        @Override
        public Builder rawState(String rawState) {
            return (Builder)Builder.class.cast(super.rawState(rawState));
        }

        @Override
        public Builder instanceType(String instanceType) {
            return (Builder)Builder.class.cast(super.instanceType(instanceType));
        }

        @Override
        public Builder ipAddress(String ipAddress) {
            return (Builder)Builder.class.cast(super.ipAddress(ipAddress));
        }

        @Override
        public Builder kernelId(String kernelId) {
            return (Builder)Builder.class.cast(super.kernelId(kernelId));
        }

        @Override
        public Builder keyName(String keyName) {
            return (Builder)Builder.class.cast(super.keyName(keyName));
        }

        @Override
        public Builder launchTime(Date launchTime) {
            return (Builder)Builder.class.cast(super.launchTime(launchTime));
        }

        @Override
        public Builder platform(String platform) {
            return (Builder)Builder.class.cast(super.platform(platform));
        }

        @Override
        public Builder privateDnsName(String privateDnsName) {
            return (Builder)Builder.class.cast(super.privateDnsName(privateDnsName));
        }

        @Override
        public Builder privateIpAddress(String privateIpAddress) {
            return (Builder)Builder.class.cast(super.privateIpAddress(privateIpAddress));
        }

        @Override
        public Builder ramdiskId(String ramdiskId) {
            return (Builder)Builder.class.cast(super.ramdiskId(ramdiskId));
        }

        @Override
        public Builder reason(String reason) {
            return (Builder)Builder.class.cast(super.reason(reason));
        }

        @Override
        public Builder region(String region) {
            return (Builder)Builder.class.cast(super.region(region));
        }

        @Override
        public Builder rootDeviceName(String rootDeviceName) {
            return (Builder)Builder.class.cast(super.rootDeviceName(rootDeviceName));
        }

        @Override
        public Builder rootDeviceType(RootDeviceType rootDeviceType) {
            return (Builder)Builder.class.cast(super.rootDeviceType(rootDeviceType));
        }

        @Override
        public Builder virtualizationType(String virtualizationType) {
            return (Builder)Builder.class.cast(super.virtualizationType(virtualizationType));
        }

        @Override
        public Builder device(String key, BlockDevice value) {
            return (Builder)Builder.class.cast(super.device(key, value));
        }

        @Override
        public Builder groupName(String groupName) {
            return (Builder)Builder.class.cast(super.groupName(groupName));
        }

        @Override
        public Builder groupNames(Iterable<String> groupNames) {
            return (Builder)Builder.class.cast(super.groupNames(groupNames));
        }

        @Override
        public AWSRunningInstance build() {
            return new AWSRunningInstance(this.region, this.securityGroupIdToNames, this.amiLaunchIndex, this.dnsName, this.imageId, this.instanceId, this.instanceState, this.rawState, this.instanceType, this.ipAddress, this.kernelId, this.keyName, this.launchTime, this.availabilityZone, this.virtualizationType, this.platform, this.privateDnsName, this.privateIpAddress, this.ramdiskId, this.reason, this.rootDeviceType, this.rootDeviceName, this.ebsBlockDevices, this.monitoringState, this.placementGroup, this.productCodes, this.subnetId, this.spotInstanceRequestId, this.vpcId, this.hypervisor, this.tags);
        }
    }
}

