/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.filters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import java.util.Comparator;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.domain.TemporaryCredentials;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.internal.SignatureWire;
import org.jclouds.http.utils.Queries;
import org.jclouds.io.InputSuppliers;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;
import org.jclouds.rest.RequestSigner;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.util.Strings2;

@Singleton
public class FormSigner
implements HttpRequestFilter,
RequestSigner {
    public static final Set<String> mandatoryParametersForSignature = ImmutableSet.of("Action", "SignatureMethod", "SignatureVersion", "Version");
    private final SignatureWire signatureWire;
    private final String apiVersion;
    private final Supplier<Credentials> creds;
    private final javax.inject.Provider<String> dateService;
    private final Crypto crypto;
    private final HttpUtils utils;
    @Resource
    @Named(value="jclouds.signature")
    private Logger signatureLog = Logger.NULL;
    private static final Comparator<String> actionFirstAccessKeyLast = new Comparator<String>(){
        static final int LEFT_IS_GREATER = 1;
        static final int RIGHT_IS_GREATER = -1;

        @Override
        public int compare(String left, String right) {
            if (left == right) {
                return 0;
            }
            if ("Action".equals(right) || "AWSAccessKeyId".equals(left)) {
                return 1;
            }
            if ("Action".equals(left) || "AWSAccessKeyId".equals(right)) {
                return -1;
            }
            return Ordering.natural().compare(left, right);
        }
    };

    @Inject
    public FormSigner(SignatureWire signatureWire, @ApiVersion String apiVersion, @Provider Supplier<Credentials> creds, @TimeStamp javax.inject.Provider<String> dateService, Crypto crypto, HttpUtils utils) {
        this.signatureWire = signatureWire;
        this.apiVersion = apiVersion;
        this.creds = creds;
        this.dateService = dateService;
        this.crypto = crypto;
        this.utils = utils;
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        Preconditions.checkNotNull(request.getFirstHeaderOrNull("Host"), "request is not ready to sign; host not present");
        Multimap<String, String> decodedParams = Queries.queryParser().apply(request.getPayload().getRawContent().toString());
        decodedParams.replaceValues("Version", ImmutableSet.of(this.apiVersion));
        this.addSigningParams(decodedParams);
        this.validateParams(decodedParams);
        String stringToSign = this.createStringToSign(request, decodedParams);
        String signature = this.sign(stringToSign);
        this.addSignature(decodedParams, signature);
        request = this.setPayload(request, decodedParams);
        this.utils.logRequest(this.signatureLog, request, "<<");
        return request;
    }

    HttpRequest setPayload(HttpRequest request, Multimap<String, String> decodedParams) {
        String queryLine = FormSigner.buildQueryLine(decodedParams);
        request.setPayload(queryLine);
        request.getPayload().getContentMetadata().setContentType("application/x-www-form-urlencoded");
        return request;
    }

    private static String buildQueryLine(Multimap<String, String> decodedParams) {
        TreeMultimap sortedParams = TreeMultimap.create(actionFirstAccessKeyLast, Ordering.natural());
        sortedParams.putAll(decodedParams);
        return Queries.encodeQueryLine(sortedParams);
    }

    @VisibleForTesting
    void validateParams(Multimap<String, String> params) {
        for (String parameter : mandatoryParametersForSignature) {
            Preconditions.checkState(params.containsKey(parameter), "parameter " + parameter + " is required for signature");
        }
    }

    @VisibleForTesting
    void addSignature(Multimap<String, String> params, String signature) {
        params.replaceValues("Signature", ImmutableList.of(signature));
    }

    @Override
    @VisibleForTesting
    public String sign(String stringToSign) {
        String signature;
        try {
            signature = CryptoStreams.base64(CryptoStreams.mac(InputSuppliers.of(stringToSign), this.crypto.hmacSHA256(this.creds.get().credential.getBytes())));
            if (this.signatureWire.enabled()) {
                this.signatureWire.input(Strings2.toInputStream(signature));
            }
        }
        catch (Exception e) {
            throw new HttpException("error signing request", e);
        }
        return signature;
    }

    @VisibleForTesting
    public String createStringToSign(HttpRequest request, Multimap<String, String> decodedParams) {
        this.utils.logRequest(this.signatureLog, request, ">>");
        StringBuilder stringToSign = new StringBuilder();
        stringToSign.append(request.getMethod()).append("\n");
        stringToSign.append(request.getFirstHeaderOrNull("Host").toLowerCase()).append("\n");
        stringToSign.append(request.getEndpoint().getPath()).append("\n");
        stringToSign.append(this.buildCanonicalizedString(decodedParams));
        if (this.signatureWire.enabled()) {
            this.signatureWire.output(stringToSign.toString());
        }
        return stringToSign.toString();
    }

    @VisibleForTesting
    String buildCanonicalizedString(Multimap<String, String> decodedParams) {
        return Queries.encodeQueryLine(TreeMultimap.create(decodedParams), ImmutableList.<Character>of());
    }

    @VisibleForTesting
    void addSigningParams(Multimap<String, String> params) {
        params.removeAll("Signature");
        params.removeAll("SecurityToken");
        Credentials current = this.creds.get();
        if (current instanceof TemporaryCredentials) {
            params.put("SecurityToken", ((TemporaryCredentials)TemporaryCredentials.class.cast(current)).getSessionToken());
        }
        params.replaceValues("SignatureMethod", ImmutableList.of("HmacSHA256"));
        params.replaceValues("SignatureVersion", ImmutableList.of("2"));
        params.replaceValues("Timestamp", ImmutableList.of(this.dateService.get()));
        params.replaceValues("AWSAccessKeyId", ImmutableList.of(this.creds.get().identity));
    }

    @Override
    public String createStringToSign(HttpRequest input) {
        return this.createStringToSign(input, Queries.queryParser().apply(input.getPayload().getRawContent().toString()));
    }
}

