/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.azure.storage.domain.BoundedSet;
import org.jclouds.azure.storage.options.ListOptions;
import org.jclouds.azureblob.AzureBlobAsyncClient;
import org.jclouds.azureblob.blobstore.functions.AzureBlobToBlob;
import org.jclouds.azureblob.blobstore.functions.BlobPropertiesToBlobMetadata;
import org.jclouds.azureblob.blobstore.functions.BlobToAzureBlob;
import org.jclouds.azureblob.blobstore.functions.ContainerToResourceMetadata;
import org.jclouds.azureblob.blobstore.functions.ListBlobsResponseToResourceList;
import org.jclouds.azureblob.blobstore.functions.ListOptionsToListBlobsOptions;
import org.jclouds.azureblob.domain.AzureBlob;
import org.jclouds.azureblob.domain.BlobProperties;
import org.jclouds.azureblob.domain.ContainerProperties;
import org.jclouds.azureblob.domain.ListBlobsResponse;
import org.jclouds.azureblob.domain.PublicAccess;
import org.jclouds.azureblob.options.CreateContainerOptions;
import org.jclouds.azureblob.options.ListBlobsOptions;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.internal.BaseAsyncBlobStore;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.concurrent.Futures;
import org.jclouds.domain.Location;

@Singleton
public class AzureAsyncBlobStore
extends BaseAsyncBlobStore {
    private final AzureBlobAsyncClient async;
    private final ContainerToResourceMetadata container2ResourceMd;
    private final ListOptionsToListBlobsOptions blobStore2AzureContainerListOptions;
    private final ListBlobsResponseToResourceList azure2BlobStoreResourceList;
    private final AzureBlobToBlob azureBlob2Blob;
    private final BlobToAzureBlob blob2AzureBlob;
    private final BlobPropertiesToBlobMetadata blob2BlobMd;
    private final BlobToHttpGetOptions blob2ObjectGetOptions;

    @Inject
    AzureAsyncBlobStore(BlobStoreContext context, BlobUtils blobUtils, @Named(value="jclouds.user-threads") ExecutorService service, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, AzureBlobAsyncClient async, ContainerToResourceMetadata container2ResourceMd, ListOptionsToListBlobsOptions blobStore2AzureContainerListOptions, ListBlobsResponseToResourceList azure2BlobStoreResourceList, AzureBlobToBlob azureBlob2Blob, BlobToAzureBlob blob2AzureBlob, BlobPropertiesToBlobMetadata blob2BlobMd, BlobToHttpGetOptions blob2ObjectGetOptions) {
        super(context, blobUtils, service, defaultLocation, locations);
        this.async = Preconditions.checkNotNull(async, "async");
        this.container2ResourceMd = Preconditions.checkNotNull(container2ResourceMd, "container2ResourceMd");
        this.blobStore2AzureContainerListOptions = Preconditions.checkNotNull(blobStore2AzureContainerListOptions, "blobStore2AzureContainerListOptions");
        this.azure2BlobStoreResourceList = Preconditions.checkNotNull(azure2BlobStoreResourceList, "azure2BlobStoreResourceList");
        this.azureBlob2Blob = Preconditions.checkNotNull(azureBlob2Blob, "azureBlob2Blob");
        this.blob2AzureBlob = Preconditions.checkNotNull(blob2AzureBlob, "blob2AzureBlob");
        this.blob2BlobMd = Preconditions.checkNotNull(blob2BlobMd, "blob2BlobMd");
        this.blob2ObjectGetOptions = Preconditions.checkNotNull(blob2ObjectGetOptions, "blob2ObjectGetOptions");
    }

    @Override
    public ListenableFuture<PageSet<? extends StorageMetadata>> list() {
        return Futures.compose(this.async.listContainers(ListOptions.Builder.includeMetadata()), new Function<BoundedSet<ContainerProperties>, PageSet<? extends StorageMetadata>>(){

            @Override
            public PageSet<? extends StorageMetadata> apply(BoundedSet<ContainerProperties> from) {
                return new PageSetImpl<StorageMetadata>(Iterables.transform(from, AzureAsyncBlobStore.this.container2ResourceMd), from.getNextMarker());
            }
        }, this.service);
    }

    @Override
    public ListenableFuture<Boolean> containerExists(String container) {
        return this.async.containerExists(container);
    }

    @Override
    public ListenableFuture<Boolean> createContainerInLocation(Location location, String container) {
        return this.async.createContainer(container, new CreateContainerOptions[0]);
    }

    @Override
    public ListenableFuture<PageSet<? extends StorageMetadata>> list(String container, ListContainerOptions options) {
        ListBlobsOptions azureOptions = this.blobStore2AzureContainerListOptions.apply(options);
        ListenableFuture<ListBlobsResponse> returnVal = this.async.listBlobs(container, azureOptions.includeMetadata());
        return Futures.compose(returnVal, this.azure2BlobStoreResourceList, this.service);
    }

    @Override
    public ListenableFuture<Void> deleteContainer(String container) {
        return this.async.deleteContainer(container);
    }

    @Override
    public ListenableFuture<Blob> getBlob(String container, String key, GetOptions options) {
        org.jclouds.http.options.GetOptions azureOptions = this.blob2ObjectGetOptions.apply(options);
        ListenableFuture<AzureBlob> returnVal = this.async.getBlob(container, key, azureOptions);
        return Futures.compose(returnVal, this.azureBlob2Blob, this.service);
    }

    @Override
    public ListenableFuture<String> putBlob(String container, Blob blob) {
        return this.async.putBlob(container, this.blob2AzureBlob.apply(blob));
    }

    @Override
    public ListenableFuture<Void> removeBlob(String container, String key) {
        return this.async.deleteBlob(container, key);
    }

    @Override
    public ListenableFuture<Boolean> blobExists(String container, String name) {
        return this.async.blobExists(container, name);
    }

    @Override
    public ListenableFuture<BlobMetadata> blobMetadata(String container, String key) {
        return Futures.compose(this.async.getBlobProperties(container, key), new Function<BlobProperties, BlobMetadata>(){

            @Override
            public BlobMetadata apply(BlobProperties from) {
                return AzureAsyncBlobStore.this.blob2BlobMd.apply(from);
            }
        }, this.service);
    }

    @Override
    protected boolean deleteAndVerifyContainerGone(String container) {
        throw new UnsupportedOperationException("please use deleteContainer");
    }

    @Override
    public ListenableFuture<String> putBlob(String container, Blob blob, PutOptions options) {
        return this.putBlob(container, blob);
    }

    @Override
    public ListenableFuture<Boolean> createContainerInLocation(Location location, String container, org.jclouds.blobstore.options.CreateContainerOptions options) {
        CreateContainerOptions createContainerOptions = new CreateContainerOptions();
        if (options.isPublicRead()) {
            createContainerOptions.withPublicAccess(PublicAccess.CONTAINER);
        }
        return this.async.createContainer(container, createContainerOptions);
    }
}

