/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.strategy.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.strategy.ListBlobsInContainer;
import org.jclouds.blobstore.strategy.ListContainerStrategy;

@Singleton
public class ListContainerAndRecurseThroughFolders
implements ListBlobsInContainer {
    protected final ListContainerStrategy lister;

    @Inject
    ListContainerAndRecurseThroughFolders(ListContainerStrategy lister) {
        this.lister = lister;
    }

    @Override
    public Set<? extends BlobMetadata> execute(String containerName, final ListContainerOptions options) {
        ArrayList<Iterable<BlobMetadata>> lists = Lists.newArrayList();
        Iterable<? extends StorageMetadata> pwdList = this.lister.execute(containerName, options);
        for (StorageMetadata md : Iterables.filter(pwdList, new Predicate<StorageMetadata>(){

            @Override
            public boolean apply(StorageMetadata input) {
                return (input.getType() == StorageType.FOLDER || input.getType() == StorageType.RELATIVE_PATH) && options.isRecursive();
            }
        })) {
            String directory = options.getDir() != null ? options.getDir() + "/" + md.getName() : md.getName();
            lists.add(this.execute(containerName, options.clone().inDirectory(directory)));
        }
        lists.add(Iterables.transform(Iterables.filter(pwdList, new Predicate<StorageMetadata>(){

            @Override
            public boolean apply(StorageMetadata input) {
                return input.getType() == StorageType.BLOB;
            }
        }), new Function<StorageMetadata, BlobMetadata>(){

            @Override
            public BlobMetadata apply(StorageMetadata from) {
                return (BlobMetadata)from;
            }
        }));
        return Sets.newLinkedHashSet(Iterables.concat(lists));
    }
}

