/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.util.internal;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.strategy.ClearListStrategy;
import org.jclouds.blobstore.strategy.CountListStrategy;
import org.jclouds.blobstore.strategy.DeleteDirectoryStrategy;
import org.jclouds.blobstore.strategy.GetDirectoryStrategy;
import org.jclouds.blobstore.strategy.MkdirStrategy;
import org.jclouds.blobstore.util.BlobUtils;

@Singleton
public class BlobUtilsImpl
implements BlobUtils {
    protected final Provider<BlobBuilder> blobBuilders;
    protected final ClearListStrategy clearContainerStrategy;
    protected final GetDirectoryStrategy getDirectoryStrategy;
    protected final MkdirStrategy mkdirStrategy;
    protected final DeleteDirectoryStrategy rmDirStrategy;
    protected final CountListStrategy countBlobsStrategy;

    @Inject
    protected BlobUtilsImpl(Provider<BlobBuilder> blobBuilders, ClearListStrategy clearContainerStrategy, GetDirectoryStrategy getDirectoryStrategy, MkdirStrategy mkdirStrategy, CountListStrategy countBlobsStrategy, DeleteDirectoryStrategy rmDirStrategy) {
        this.blobBuilders = Preconditions.checkNotNull(blobBuilders, "blobBuilders");
        this.clearContainerStrategy = Preconditions.checkNotNull(clearContainerStrategy, "clearContainerStrategy");
        this.getDirectoryStrategy = Preconditions.checkNotNull(getDirectoryStrategy, "getDirectoryStrategy");
        this.mkdirStrategy = Preconditions.checkNotNull(mkdirStrategy, "mkdirStrategy");
        this.rmDirStrategy = Preconditions.checkNotNull(rmDirStrategy, "rmDirStrategy");
        this.countBlobsStrategy = Preconditions.checkNotNull(countBlobsStrategy, "countBlobsStrategy");
    }

    @Override
    public BlobBuilder blobBuilder() {
        return this.blobBuilders.get();
    }

    @Override
    public boolean directoryExists(String containerName, String directory) {
        return this.getDirectoryStrategy.execute(containerName, directory) != null;
    }

    @Override
    public void createDirectory(String containerName, String directory) {
        this.mkdirStrategy.execute(containerName, directory);
    }

    @Override
    public long countBlobs(String container, ListContainerOptions options) {
        return this.countBlobsStrategy.execute(container, options);
    }

    @Override
    public void clearContainer(String container, ListContainerOptions options) {
        this.clearContainerStrategy.execute(container, options);
    }

    @Override
    public void deleteDirectory(String container, String directory) {
        this.rmDirStrategy.execute(container, directory);
    }
}

