/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudfiles.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.Uris;
import org.jclouds.openstack.swift.domain.ObjectInfo;

@Singleton
public class PublicUriForObjectInfo
implements Function<ObjectInfo, URI> {
    private final LoadingCache<String, URI> cdnContainer;
    private static final URI NEGATIVE_ENTRY = URI.create("http://127.0.0.1");

    @Inject
    public PublicUriForObjectInfo(LoadingCache<String, URI> cdnContainer) {
        this.cdnContainer = cdnContainer;
    }

    @Override
    public URI apply(ObjectInfo from) {
        if (from == null) {
            return null;
        }
        String containerName = from.getContainer();
        if (containerName == null) {
            return null;
        }
        try {
            URI uri = this.cdnContainer.getUnchecked(containerName);
            if (uri == NEGATIVE_ENTRY) {
                return null;
            }
            return Uris.uriBuilder(uri).clearQuery().appendPath(from.getName()).build();
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            this.cdnContainer.put(containerName, NEGATIVE_ENTRY);
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }
}

