/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;

public class Item {
    @Nullable
    protected final String uuid;
    protected final String name;
    protected final Set<String> use;

    public Item(@Nullable String uuid, String name, Iterable<String> use) {
        this.uuid = uuid;
        this.name = Preconditions.checkNotNull(name, "name");
        this.use = ImmutableSet.copyOf(Preconditions.checkNotNull(use, "use"));
    }

    @Nullable
    public String getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getUse() {
        return this.use;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.use == null ? 0 : ((Object)this.use).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Item other = (Item)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.use == null ? other.use != null : !((Object)this.use).equals(other.use));
    }

    public String toString() {
        return "[uuid=" + this.uuid + ", name=" + this.name + ", use=" + this.use + "]";
    }

    public static class Builder {
        protected String uuid;
        protected String name;
        protected Set<String> use = ImmutableSet.of();

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder use(Iterable<String> use) {
            this.use = ImmutableSet.copyOf(Preconditions.checkNotNull(use, "use"));
            return this;
        }

        public Item build() {
            return new Item(this.uuid, this.name, this.use);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.use == null ? 0 : ((Object)this.use).hashCode());
            result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Builder other = (Builder)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.use == null ? other.use != null : !((Object)this.use).equals(other.use)) {
                return false;
            }
            return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
        }
    }
}

