/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.functions;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudsigma.domain.ProfileInfo;
import org.jclouds.cloudsigma.functions.ListOfKeyValuesDelimitedByBlankLinesToListOfMaps;
import org.jclouds.cloudsigma.functions.MapToProfileInfo;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ReturnStringIf2xx;

@Singleton
public class ListOfKeyValuesDelimitedByBlankLinesToProfileInfoSet
implements Function<HttpResponse, Set<ProfileInfo>> {
    private final ReturnStringIf2xx returnStringIf200;
    private final ListOfKeyValuesDelimitedByBlankLinesToListOfMaps mapConverter;
    private final MapToProfileInfo mapToProfile;

    @Inject
    ListOfKeyValuesDelimitedByBlankLinesToProfileInfoSet(ReturnStringIf2xx returnStringIf200, ListOfKeyValuesDelimitedByBlankLinesToListOfMaps mapConverter, MapToProfileInfo mapToProfile) {
        this.returnStringIf200 = returnStringIf200;
        this.mapConverter = mapConverter;
        this.mapToProfile = mapToProfile;
    }

    @Override
    public Set<ProfileInfo> apply(HttpResponse response) {
        String text = this.returnStringIf200.apply(response);
        if (text == null || text.trim().equals("")) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf(Iterables.transform(this.mapConverter.apply(text), this.mapToProfile));
    }
}

